/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws;

import fitlibrary.mockWebServices.MockingWebServices;
import fitlibrary.mockWebServices.logger.MockLogger;
import fitlibrary.mockWebServices.transactionFixture.Soap11TransactionFixture;
import fitlibrary.mockWebServices.transactionFixture.Soap12TransactionFixture;
import fitlibrary.mockWebServices.transactionFixture.SoapFullTransactionFixture;
import fitlibrary.mockWebServices.transactionFixture.TextTransactionFixture;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.ws.message.ContentType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;

public class MockWebServicesFixture
extends DoTraverse {
    protected MockingWebServices mockingWebServices = new MockingWebServices();
    protected Map<String, String> nameSpaceMap = new HashMap<String, String>();

    public TextTransactionFixture mockPlainTextOnPort(int port) {
        return new TextTransactionFixture(port, this.mockingWebServices);
    }

    public SoapFullTransactionFixture mockFullSoapAsOnPort(ContentType contentType, int port) {
        return new SoapFullTransactionFixture(contentType, port, this.mockingWebServices);
    }

    public Soap11TransactionFixture mockSoap11OnPort(int port) {
        return new Soap11TransactionFixture(port, this.mockingWebServices);
    }

    public Soap12TransactionFixture mockSoap12OnPort(int port) {
        return new Soap12TransactionFixture(port, this.mockingWebServices);
    }

    public void nameSpace(String prefix) {
        this.nameSpaceMap.put(prefix, "urn:" + prefix);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(this.nameSpaceMap));
    }

    public boolean close() throws IOException {
        MockLogger logger = this.mockingWebServices.close(100);
        this.showAfterTable(logger.report());
        return !logger.hasErrors();
    }

    public boolean closeAfterSeconds(int seconds) throws IOException {
        return this.closeAfter(seconds * 1000);
    }

    public boolean closeAfter(int milliseconds) throws IOException {
        MockLogger logger = this.mockingWebServices.close(milliseconds);
        this.showAfterTable(logger.report());
        return !logger.hasErrors();
    }

    public void sleep(int time) throws InterruptedException {
        Thread.sleep(time);
    }

    public void tearDown() throws Exception {
        this.mockingWebServices.close(100);
    }
}

