/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.logger;

import fitlibrary.mockWebServices.logger.ClockedLogger;
import fitlibrary.ws.clock.Clock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestClockedLogger {
    Mockery context = new JUnit4Mockery();
    final Clock clock = (Clock)this.context.mock(Clock.class);
    final ClockedLogger clockedLogger = new ClockedLogger(this.clock);

    @Test
    public void initialState() {
        Assert.assertThat((Object)this.clockedLogger.hasErrors(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.clockedLogger.report(), (Matcher)Matchers.equalTo((Object)"Requests = 0\nErrors = 0\nUnused = 0\n"));
    }

    @Test
    public void error() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Clock)this.one(TestClockedLogger.this.clock)).dateTime();
                this.will(1.returnValue((Object)"12:34"));
            }
        });
        this.clockedLogger.error("ERR");
        Assert.assertThat((Object)this.clockedLogger.hasErrors(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.clockedLogger.report(), (Matcher)Matchers.equalTo((Object)"Requests = 0\nErrors = 1\nUnused = 0\n12:34 Error: ERR\n"));
    }

    @Test
    public void unused() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Clock)this.one(TestClockedLogger.this.clock)).dateTime();
                this.will(2.returnValue((Object)"12:34"));
            }
        });
        this.clockedLogger.unused(1, "ERR");
        Assert.assertThat((Object)this.clockedLogger.hasErrors(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.clockedLogger.report(), (Matcher)Matchers.equalTo((Object)"Requests = 0\nErrors = 0\nUnused = 1\n12:34 Unused on 1: ERR\n"));
    }

    @Test
    public void log() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Clock)this.one(TestClockedLogger.this.clock)).dateTime();
                this.will(3.returnValue((Object)"12:34"));
            }
        });
        this.clockedLogger.log("LOG");
        Assert.assertThat((Object)this.clockedLogger.hasErrors(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.clockedLogger.report(), (Matcher)Matchers.equalTo((Object)"Requests = 0\nErrors = 0\nUnused = 0\n12:34 LOG\n"));
    }

    @Test
    public void errorsAndLogs() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Clock)this.one(TestClockedLogger.this.clock)).dateTime();
                this.will(4.returnValue((Object)"12:34"));
                ((Clock)this.one(TestClockedLogger.this.clock)).dateTime();
                this.will(4.returnValue((Object)"12:36"));
                ((Clock)this.one(TestClockedLogger.this.clock)).dateTime();
                this.will(4.returnValue((Object)"12:38"));
                ((Clock)this.one(TestClockedLogger.this.clock)).dateTime();
                this.will(4.returnValue((Object)"12:41"));
            }
        });
        this.clockedLogger.error("ERR");
        this.clockedLogger.log("LOG");
        this.clockedLogger.error("WHOOPS");
        this.clockedLogger.log("FROG");
        Assert.assertThat((Object)this.clockedLogger.hasErrors(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.clockedLogger.report(), (Matcher)Matchers.equalTo((Object)"Requests = 0\nErrors = 2\nUnused = 0\n12:34 Error: ERR\n12:36 LOG\n12:38 Error: WHOOPS\n12:41 FROG\n"));
    }
}

