/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.requestMatcher;

import fitlibrary.mockWebServices.requestMatcher.AcceptAnyRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.PatternRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TestPatternRequestMatcher {
    private RequestMatcher literalMatcher = new PatternRequestMatcher("a  X  b");
    private RequestMatcher patternMatcher = new PatternRequestMatcher("a.*b");
    private final Message request = TestPatternRequestMatcher.msg("a  X  b");

    @Test
    public void matchLiteral() throws Exception {
        Assert.assertThat((Object)this.literalMatcher.match(this.request), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.literalMatcher.match(TestPatternRequestMatcher.msg("a  b X")), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void matchPattern() throws Exception {
        Assert.assertThat((Object)this.patternMatcher.match(this.request), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.patternMatcher.match(TestPatternRequestMatcher.msg("abX")), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void and() throws Exception {
        AcceptAnyRequestMatcher acceptAnyRequestMatcher = new AcceptAnyRequestMatcher();
        Assert.assertThat((Object)this.patternMatcher.and(acceptAnyRequestMatcher).match(this.request), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.patternMatcher.and(acceptAnyRequestMatcher).match(TestPatternRequestMatcher.msg("b")), (Matcher)Matchers.equalTo((Object)false));
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

