/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.term;

import fitlibrary.mockWebServices.logger.MockLogger;
import fitlibrary.mockWebServices.responder.LiteralResponder;
import fitlibrary.mockWebServices.responder.Responder;
import fitlibrary.mockWebServices.term.RepeatingTerm;
import fitlibrary.mockWebServices.term.Term;
import fitlibrary.ws.message.ContentType;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestRepeatingTerm {
    final Mockery context = new JUnit4Mockery();
    static final Responder SOME = new LiteralResponder("aa", ContentType.PLAIN);
    final Term t1 = (Term)this.context.mock(Term.class, "term1");
    final Message request = TestRepeatingTerm.msg("request");
    final MockLogger logger = (MockLogger)this.context.mock(MockLogger.class);

    @Test
    public void alwaysAvailableAndNeverUnused() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Term)this.one(TestRepeatingTerm.this.t1)).setComposite((Term)this.with(1.any(RepeatingTerm.class)));
                ((Term)this.exactly(2).of((Object)TestRepeatingTerm.this.t1)).matchRequest(TestRepeatingTerm.this.request);
                this.will(1.returnValue((Object)SOME));
            }
        });
        RepeatingTerm repeatingTerm = new RepeatingTerm(this.t1);
        Assert.assertThat((Object)repeatingTerm.available(), (Matcher)Matchers.equalTo((Object)true));
        repeatingTerm.logUnused(1, this.logger);
        Assert.assertThat((Object)repeatingTerm.matchRequest(this.request), (Matcher)Matchers.equalTo((Object)SOME));
        Assert.assertThat((Object)repeatingTerm.available(), (Matcher)Matchers.equalTo((Object)true));
        repeatingTerm.logUnused(1, this.logger);
        Assert.assertThat((Object)repeatingTerm.matchRequest(this.request), (Matcher)Matchers.equalTo((Object)SOME));
        Assert.assertThat((Object)repeatingTerm.available(), (Matcher)Matchers.equalTo((Object)true));
        repeatingTerm.logUnused(1, this.logger);
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

