/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator;

import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fit.decorator.FixtureDecorator;
import fit.decorator.Loop;
import fit.decorator.TestFixture;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.TestCaseHelper;
import fit.decorator.util.Timer;
import java.text.ParseException;
import junit.framework.TestCase;

public abstract class FixtureDecoratorTestCase
extends TestCase {
    protected static final long ELAPSED = 20L;
    protected Timer stopWatch = new Timer(){

        @Override
        public void start() {
        }

        @Override
        public long elapsed() {
            return 20L;
        }
    };

    public void testShouldBeAbleToExecuteEncapsulatedFixture() throws ParseException {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>100</td><td>4</td><td>25</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        int right = 1 + this.numberOfAssertionsOnDecorator();
        TestCaseHelper.assertCounts(TestCaseHelper.counts(right, 0, 0, 0), decorator.counts);
    }

    public void testShouldBeAbleToFindEncapsulatedFixtureName() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>eg.Division</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        String encapsulatedFixtureName = (String)decorator.summary.get("EncapsulatedFixtureName");
        FixtureDecoratorTestCase.assertEquals((String)"eg.Division", (String)encapsulatedFixtureName);
    }

    public void testShouldBeAbleToInstantiateEncapsulatedFixture() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>" + TestFixture.class.getName() + "</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        String encapsulatedFixtureName = (String)decorator.summary.get("EncapsulatedFixtureName");
        FixtureDecoratorTestCase.assertEquals((String)"fit.decorator.TestFixture", (String)encapsulatedFixtureName);
    }

    public void testShouldDoNothingIfThereIsNoEncapsulatedFixturePresent() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "</table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        FixtureDecoratorTestCase.assertNull((Object)decorator.summary.get("EncapsulatedFixtureName"));
        TestCaseHelper.assertCounts(TestCaseHelper.counts(0, 0, 0, 0), decorator.counts);
    }

    public void testShouldMarkExceptionIfEncapsulatingFixtureNameIsInvalid() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>invalidClass</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        FixtureDecoratorTestCase.assertEquals((int)1, (int)decorator.counts.exceptions);
        String encapsulatedFixtureName = (String)decorator.summary.get("EncapsulatedFixtureName");
        FixtureDecoratorTestCase.assertEquals((String)"invalidClass", (String)encapsulatedFixtureName);
    }

    public void testShouldStripFirstRowAndPassRestOfTheTableToEncapsulatedFixture() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>" + TestFixture.class.getName() + "</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        String expectedTableContents = "<table><tr><td>" + TestFixture.class.getName() + "</td></tr></table>";
        FixtureDecoratorTestCase.assertEquals((Object)expectedTableContents, (Object)decorator.summary.get("tableContents"));
    }

    public void testShouldHandleInvalidInputExceptionIfThrownBySetUpMethod() throws Exception {
        String fitPage = "<table>" + this.geWrongDecoratorHTMLRow() + "<tr><td>" + TestFixture.class.getName() + "</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        TestCaseHelper.assertCounts(TestCaseHelper.counts(0, 0, 0, 1), decorator.counts);
    }

    public void testSetAlternativeArgsShouldStoreOddNumberedColumnsToArgsVariable() throws Exception {
        String fitPage = "<table><tr><td>xyz</td><td>1</td><td>skip1</td><td>2</td><td>skip2</td><td>3</td><td>skip3</td></tr></table>";
        FixtureDecorator decorator = this.dummyFitDecorator();
        Parse table = new Parse(fitPage);
        decorator.setAlternativeArgs(table);
        this.assertArray(new String[]{"1", "2", "3"}, decorator.getArgs());
    }

    public void testSetAlternativeArgsShouldIgnoreExpectedAndActualStrings() throws Exception {
        String fitPage = "<table><tr><td>xyz</td><td>1</td><td>skip1</td><td>2<hr>actual 4</td><td>skip2</td><td>3</td><td>skip3</td></tr></table>";
        FixtureDecorator decorator = this.dummyFitDecorator();
        Parse table = new Parse(fitPage);
        decorator.setAlternativeArgs(table);
        this.assertArray(new String[]{"1", "2", "3"}, decorator.getArgs());
    }

    private FixtureDecorator dummyFitDecorator() {
        FixtureDecorator decorator = new FixtureDecorator(){

            @Override
            protected void setupDecorator(String[] args) throws InvalidInputException {
            }

            @Override
            protected void updateColumnsBasedOnResults(Parse table) {
            }
        };
        return decorator;
    }

    private void assertArray(String[] expected, String[] actual) {
        FixtureDecoratorTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            FixtureDecoratorTestCase.assertEquals((String)expected[i], (String)actual[i]);
        }
    }

    private String geWrongDecoratorHTMLRow() {
        return "<tr><td>" + Loop.class.getName() + "</td></tr>";
    }

    protected abstract String geDecoratorHTMLRow();

    protected abstract int numberOfAssertionsOnDecorator();

    protected void executeAndAssert(Counts expected, String fitPage, Fixture fixture) throws ParseException {
        fixture.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts(expected, fixture.counts);
    }
}

