/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.nio.ByteBuffer;

public class ChunkedResponse
extends Response {
    private ResponseSender sender;
    private int bytesSent = 0;
    private boolean isReadyToSend = false;
    private boolean dontChunk = false;

    public ChunkedResponse(String format) {
        super(format);
        if (this.isTextFormat()) {
            this.dontChunk = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readyToSend(ResponseSender sender) throws Exception {
        this.sender = sender;
        this.addStandardHeaders();
        sender.send(this.makeHttpHeaders().getBytes());
        this.setReadyToSend(true);
        ChunkedResponse chunkedResponse = this;
        synchronized (chunkedResponse) {
            this.notifyAll();
            Thread.yield();
        }
    }

    public synchronized boolean isReadyToSend() {
        return this.isReadyToSend;
    }

    @Override
    protected void addSpecificHeaders() {
        if (!this.dontChunk) {
            this.addHeader("Transfer-Encoding", "chunked");
        }
    }

    public static String asHex(int value) {
        return Integer.toHexString(value);
    }

    public void add(String text) throws Exception {
        if (text != null) {
            this.add(this.getEncodedBytes(text));
        }
    }

    public void add(byte[] bytes) throws Exception {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        if (this.dontChunk) {
            this.sender.send(bytes);
        } else {
            String sizeLine = ChunkedResponse.asHex(bytes.length) + "\r\n";
            ByteBuffer chunk = ByteBuffer.allocate(sizeLine.length() + bytes.length + 2);
            chunk.put(sizeLine.getBytes()).put(bytes).put("\r\n".getBytes());
            this.sender.send(chunk.array());
        }
        this.bytesSent += bytes.length;
    }

    public void addTrailingHeader(String key, String value) throws Exception {
        String header = key + ": " + value + "\r\n";
        this.sender.send(header.getBytes());
    }

    public void closeChunks() throws Exception {
        this.sender.send("0\r\n".getBytes());
    }

    public void closeTrailer() throws Exception {
        this.sender.send("\r\n".getBytes());
    }

    public void close() throws Exception {
        this.sender.close();
    }

    public void closeAll() throws Exception {
        this.closeChunks();
        this.closeTrailer();
        this.close();
    }

    @Override
    public int getContentSize() {
        return this.bytesSent;
    }

    private synchronized void setReadyToSend(boolean isReadyToSend) {
        this.isReadyToSend = isReadyToSend;
    }

    public void turnOffChunking() {
        this.dontChunk = true;
    }

    public boolean isChunkingTurnedOff() {
        return this.dontChunk;
    }
}

