/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.VelocityFactory;
import fitnesse.responders.run.CompositeExecutionLog;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.responders.run.slimResponder.SlimTestSystem;
import fitnesse.slimTables.HtmlTable;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.Table;
import fitnesse.wiki.WikiPage;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import util.TimeMeasurement;

public class XmlFormatter
extends BaseFormatter {
    private WriterFactory writerFactory;
    private long currentTestStartTime;
    private StringBuilder outputBuffer;
    private TestSystem testSystem;
    protected TestExecutionReport testResponse = new TestExecutionReport();
    protected TestSummary finalSummary = new TestSummary();

    public XmlFormatter(FitNesseContext context, WikiPage page, WriterFactory writerFactory) throws Exception {
        super(context, page);
        this.writerFactory = writerFactory;
    }

    @Override
    public void newTestStarted(WikiPage test, TimeMeasurement timeMeasurement) throws Exception {
        this.currentTestStartTime = timeMeasurement.startedAt();
        this.appendHtmlToBuffer(this.getPage().getData().getHeaderPageHtml());
    }

    @Override
    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) throws Exception {
        this.testSystem = testSystem;
    }

    @Override
    public void testOutputChunk(String output) throws Exception {
        this.appendHtmlToBuffer(output);
    }

    @Override
    public void testComplete(WikiPage test, TestSummary testSummary, TimeMeasurement timeMeasurement) throws Exception {
        super.testComplete(test, testSummary, timeMeasurement);
        this.processTestResults(test.getName(), testSummary, timeMeasurement);
    }

    public void processTestResults(String relativeTestName, TestSummary testSummary, TimeMeasurement timeMeasurement) throws Exception {
        this.finalSummary = new TestSummary(testSummary);
        TestExecutionReport.TestResult currentResult = this.newTestResult();
        this.testResponse.results.add(currentResult);
        currentResult.startTime = this.currentTestStartTime;
        currentResult.content = this.outputBuffer == null ? null : this.outputBuffer.toString();
        this.outputBuffer = null;
        this.addCountsToResult(currentResult, testSummary);
        currentResult.runTimeInMillis = String.valueOf(timeMeasurement.elapsed());
        currentResult.relativePageName = relativeTestName;
        currentResult.tags = this.page.getData().getAttribute("Suites");
        if (this.testSystem instanceof SlimTestSystem) {
            SlimTestSystem slimSystem = (SlimTestSystem)this.testSystem;
            new SlimTestXmlFormatter(currentResult, slimSystem).invoke();
        }
    }

    protected TestExecutionReport.TestResult newTestResult() {
        return new TestExecutionReport.TestResult();
    }

    @Override
    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) throws Exception {
    }

    @Override
    public void writeHead(String pageType) throws Exception {
        this.writeHead(this.getPage());
    }

    protected void writeHead(WikiPage testPage) throws Exception {
        this.testResponse.version = new FitNesseVersion().toString();
        this.testResponse.rootPath = testPage.getName();
    }

    @Override
    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws Exception {
        super.allTestingComplete(totalTimeMeasurement);
        this.setTotalRunTimeOnReport(totalTimeMeasurement);
        this.writeResults();
    }

    protected void setTotalRunTimeOnReport(TimeMeasurement totalTimeMeasurement) {
        this.testResponse.setTotalRunTimeInMillis(totalTimeMeasurement);
    }

    protected void writeResults() throws Exception {
        this.writeResults(this.writerFactory.getWriter(this.context, this.getPageForHistory(), this.finalSummary, this.currentTestStartTime));
    }

    protected WikiPage getPageForHistory() {
        return this.page;
    }

    @Override
    public int getErrorCount() {
        return this.finalSummary.wrong + this.finalSummary.exceptions;
    }

    protected void writeResults(Writer writer) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("response", this.testResponse);
        Template template = VelocityFactory.getVelocityEngine().getTemplate("testResults.vm");
        template.merge(velocityContext, writer);
        writer.close();
    }

    protected TestSummary getFinalSummary() {
        return this.finalSummary;
    }

    private void addCountsToResult(TestExecutionReport.TestResult currentResult, TestSummary testSummary) {
        currentResult.right = Integer.toString(testSummary.getRight());
        currentResult.wrong = Integer.toString(testSummary.getWrong());
        currentResult.ignores = Integer.toString(testSummary.getIgnores());
        currentResult.exceptions = Integer.toString(testSummary.getExceptions());
    }

    private void appendHtmlToBuffer(String output) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new StringBuilder();
        }
        this.outputBuffer.append(output);
    }

    private static class SlimTestXmlFormatter {
        private TestExecutionReport.TestResult testResult;
        private List<Object> instructions;
        private Map<String, Object> results;
        private List<SlimTable.Expectation> expectations;
        private List<SlimTable> slimTables;

        public SlimTestXmlFormatter(TestExecutionReport.TestResult testResult, SlimTestSystem slimSystem) {
            this.testResult = testResult;
            this.instructions = slimSystem.getInstructions();
            this.results = slimSystem.getInstructionResults();
            this.expectations = slimSystem.getExpectations();
            this.slimTables = slimSystem.getTestTables();
        }

        public void invoke() {
            this.addTables();
            this.addInstructionResults();
        }

        private void addTables() {
            if (this.slimTables.size() > 0) {
                for (SlimTable slimTable : this.slimTables) {
                    this.addTable(slimTable);
                }
            }
        }

        private void addTable(SlimTable slimTable) {
            TestExecutionReport.Table resultTable = new TestExecutionReport.Table(slimTable.getTableName());
            this.testResult.tables.add(resultTable);
            this.addRowsToTable(slimTable, resultTable);
            this.addChildTables(slimTable);
        }

        private void addChildTables(SlimTable slimTable) {
            for (SlimTable child : slimTable.getChildren()) {
                this.addTable(child);
            }
        }

        private void addRowsToTable(SlimTable slimTable, TestExecutionReport.Table resultTable) {
            Table table = slimTable.getTable();
            int rows = table.getRowCount();
            for (int row = 0; row < rows; ++row) {
                this.addRowToTable(resultTable, table, row);
            }
        }

        private void addRowToTable(TestExecutionReport.Table resultTable, Table table, int row) {
            TestExecutionReport.Row resultRow = new TestExecutionReport.Row();
            resultTable.add(resultRow);
            int cols = table.getColumnCountInRow(row);
            for (int col = 0; col < cols; ++col) {
                String contents = table.getCellContents(col, row);
                if (this.isScenarioHtml(contents)) {
                    this.addColorizedScenarioReference(resultRow, contents);
                    continue;
                }
                String colorizedContents = HtmlTable.colorize(contents);
                resultRow.add(colorizedContents);
            }
        }

        private void addColorizedScenarioReference(TestExecutionReport.Row resultRow, String contents) {
            String status = SlimTestXmlFormatter.getTestStatus(contents);
            String tableName = this.getTableName(contents);
            resultRow.add(String.format("%s(scenario:%s)", status, tableName));
        }

        private String getTableName(String contents) {
            return SlimTestXmlFormatter.getStringBetween(contents, "table_name=\"", "\"");
        }

        private static String getTestStatus(String contents) {
            return SlimTestXmlFormatter.getStringBetween(contents, "<span id=\"test_status\" class=", ">Scenario</span>");
        }

        private static String getStringBetween(String contents, String prefix, String suffix) {
            int start = contents.indexOf(prefix) + prefix.length();
            int end = contents.indexOf(suffix, start);
            return contents.substring(start, end);
        }

        private boolean isScenarioHtml(String contents) {
            return contents.startsWith("<div class=\"collapse_rim\">");
        }

        private void addInstructionResults() {
            for (Object instruction : this.instructions) {
                this.addInstructionResult(instruction);
            }
        }

        private void addInstructionResult(Object instruction) {
            TestExecutionReport.InstructionResult instructionResult = new TestExecutionReport.InstructionResult();
            this.testResult.instructions.add(instructionResult);
            List instructionList = (List)instruction;
            String id = (String)instructionList.get(0);
            Object result = this.results.get(id);
            instructionResult.instruction = instruction.toString();
            instructionResult.slimResult = result != null ? result.toString() : "";
            for (SlimTable.Expectation expectation : this.expectations) {
                if (!expectation.getInstructionTag().equals(id)) continue;
                try {
                    String message;
                    TestExecutionReport.Expectation expectationResult = new TestExecutionReport.Expectation();
                    instructionResult.addExpectation(expectationResult);
                    expectationResult.instructionId = expectation.getInstructionTag();
                    expectationResult.col = Integer.toString(expectation.getCol());
                    expectationResult.row = Integer.toString(expectation.getRow());
                    expectationResult.type = expectation.getClass().getSimpleName();
                    expectationResult.actual = expectation.getActual();
                    expectationResult.expected = expectation.getExpected();
                    expectationResult.evaluationMessage = message = expectation.getEvaluationMessage();
                    expectationResult.status = this.expectationStatus(message);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        private String expectationStatus(String message) {
            String status = "TILT";
            status = message.matches(".*pass(.*)") ? "right" : (message.matches(".*fail(.*)") ? "wrong" : (message.matches(".*__EXCEPTION__:<") ? "exception" : "ignored"));
            return status;
        }
    }

    public static interface WriterFactory {
        public Writer getWriter(FitNesseContext var1, WikiPage var2, TestSummary var3, long var4) throws Exception;
    }
}

