/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TableTable
extends SlimTable {
    private String doTableId;

    public TableTable(Table table, String tableId, SlimTestContext slimTestContext) {
        super(table, tableId, slimTestContext);
    }

    @Override
    protected String getTableType() {
        return "tableTable";
    }

    @Override
    public void appendInstructions() {
        this.constructFixture();
        this.doTableId = this.callFunction(this.getTableName(), "doTable", this.tableAsList());
    }

    @Override
    public void evaluateReturnValues(Map<String, Object> returnValues) throws Exception {
        if (this.doTableId == null || returnValues.get(this.doTableId) == null) {
            this.table.appendToCell(0, 0, this.error("Table fixture has no valid doTable method"));
            return;
        }
        Object tableReturn = returnValues.get(this.doTableId);
        if (tableReturn instanceof String) {
            String value = (String)tableReturn;
            if (this.isTestCaseErrorMessage(value)) {
                this.table.appendToCell(0, 0, this.error("Table fixture has no valid doTable method"));
            } else if (this.isExceptionFailureMessage(value)) {
                this.table.appendToCell(0, 0, this.error(value));
            }
            return;
        }
        this.resizeTableAndEvaluateRows(returnValues);
    }

    private boolean isExceptionFailureMessage(String value) {
        return value.startsWith("Exception: ");
    }

    private boolean isTestCaseErrorMessage(String value) {
        return value.startsWith("!error:");
    }

    private void resizeTableAndEvaluateRows(Map<String, Object> returnValues) throws Exception {
        List tableResults = (List)returnValues.get(this.doTableId);
        this.extendTable(this.table, tableResults);
        for (int row = 0; row < tableResults.size(); ++row) {
            this.evaluateRow(tableResults, row);
        }
    }

    private void extendTable(Table table, List<List<Object>> tableResults) throws Exception {
        this.addNewRows(table, tableResults);
        this.extendExistingRows(table, tableResults);
    }

    private void addNewRows(Table table, List<List<Object>> tableResults) throws Exception {
        while (table.getRowCount() - 1 < tableResults.size()) {
            ArrayList<String> l = new ArrayList<String>();
            for (Object s : tableResults.get(table.getRowCount() - 1)) {
                l.add((String)s);
            }
            table.addRow(l);
        }
    }

    private void extendExistingRows(Table table, List<List<Object>> tableResults) throws Exception {
        for (int row = 1; row < tableResults.size(); ++row) {
            this.extendRow(table, row, tableResults.get(row - 1));
        }
    }

    private void extendRow(Table table, int row, List<Object> cellList) throws Exception {
        while (table.getColumnCountInRow(row) < cellList.size()) {
            table.appendCellToRow(row, (String)cellList.get(table.getColumnCountInRow(row)));
        }
    }

    private void evaluateRow(List<List<Object>> tableResults, int resultRow) {
        List<Object> rowList = tableResults.get(resultRow);
        for (int col = 0; col < rowList.size(); ++col) {
            int tableRow = resultRow + 1;
            String contents = this.table.getCellContents(col, tableRow);
            String replacedContents = this.replaceSymbolsWithFullExpansion(contents);
            this.table.setCell(col, tableRow, replacedContents);
            String result = (String)rowList.get(col);
            this.colorCell(col, tableRow, result);
        }
    }

    private void colorCell(int col, int row, String result) {
        if (result.equalsIgnoreCase("no change") || result.length() == 0) {
            return;
        }
        if (result.equalsIgnoreCase("pass")) {
            this.pass(col, row);
        } else if (result.equalsIgnoreCase("fail")) {
            this.fail(col, row, this.table.getCellContents(col, row));
        } else if (result.equalsIgnoreCase("ignore")) {
            this.ignore(col, row, this.table.getCellContents(col, row));
        } else if (!this.colorCellWithMessage(col, row, result)) {
            this.fail(col, row, result);
        }
    }

    private boolean colorCellWithMessage(int col, int row, String contents) {
        int colon = contents.indexOf(":");
        if (colon == -1) {
            return false;
        }
        String code = contents.substring(0, colon);
        String message = contents.substring(colon + 1);
        if (code.equalsIgnoreCase("error")) {
            this.table.setCell(col, row, this.error(message));
        } else if (code.equalsIgnoreCase("fail")) {
            this.table.setCell(col, row, this.fail(message));
        } else if (code.equalsIgnoreCase("pass")) {
            this.table.setCell(col, row, this.pass(message));
        } else if (code.equalsIgnoreCase("ignore")) {
            this.table.setCell(col, row, this.ignore(message));
        } else if (code.equalsIgnoreCase("report")) {
            this.table.setCell(col, row, message);
        } else {
            return false;
        }
        return true;
    }
}

