/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.WidgetVisitor;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.PreProcessorLiteralWidget;
import fitnesse.wikitext.widgets.TextWidget;
import fitnesse.wikitext.widgets.VariableExpandingWidgetRoot;
import fitnesse.wikitext.widgets.WidgetRoot;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class ParentWidget
extends WikiWidget {
    protected LinkedList<WikiWidget> children = new LinkedList();
    private int currentChild = 0;
    public static WidgetBuilder preprocessingLiteralWidgetBuilder = new WidgetBuilder(PreProcessorLiteralWidget.class);

    public ParentWidget(ParentWidget parent) {
        super(parent);
    }

    public ParentWidget(ParentWidget alias, boolean isAlias) {
        super(null);
        this.parent = alias.parent;
        if (isAlias) {
            this.children = alias.children;
            this.currentChild = alias.currentChild;
        } else {
            this.addToParent();
        }
    }

    public WidgetRoot getRoot() {
        return this.parent.getRoot();
    }

    public void reset() {
        this.children.clear();
        this.currentChild = 0;
    }

    public void addChild(WikiWidget widget) {
        this.children.add(widget);
    }

    public int numberOfChildren() {
        return this.children.size();
    }

    public List<WikiWidget> getChildren() {
        return this.children;
    }

    public WikiWidget nextChild() {
        if (this.hasNextChild()) {
            return this.children.get(this.currentChild++);
        }
        throw new ArrayIndexOutOfBoundsException("No next child exists");
    }

    public boolean hasNextChild() {
        return this.currentChild < this.numberOfChildren();
    }

    public String childHtml() throws Exception {
        this.currentChild = 0;
        StringBuffer html = new StringBuffer();
        while (this.hasNextChild()) {
            WikiWidget child = this.nextChild();
            html.append(child.render());
        }
        return html.toString();
    }

    public String childWikiText() throws Exception {
        this.currentChild = 0;
        StringBuffer wikiText = new StringBuffer();
        while (this.hasNextChild()) {
            WikiWidget child = this.nextChild();
            wikiText.append(child.asWikiText());
        }
        return wikiText.toString();
    }

    public int defineLiteral(String literal) {
        return this.parent.defineLiteral(literal);
    }

    public String getLiteral(int literalNumber) {
        return this.parent.getLiteral(literalNumber);
    }

    public void addVariable(String key, String value) {
        this.parent.addVariable(key, value);
    }

    public String getVariable(String key) throws Exception {
        return this.parent.getVariable(key);
    }

    public void addChildWidgets(String value) throws Exception {
        this.getBuilder().addChildWidgets(value, this);
    }

    public WidgetBuilder getBuilder() {
        return this.parent.getBuilder();
    }

    public boolean doEscaping() {
        return this.parent.doEscaping();
    }

    public boolean preProcessingComplete() {
        return this.children.size() == 1 && this.children.get(0) instanceof TextWidget;
    }

    @Override
    public void acceptVisitor(WidgetVisitor visitor) throws Exception {
        visitor.visit(this);
        this.currentChild = 0;
        while (this.hasNextChild()) {
            WikiWidget child = this.nextChild();
            child.acceptVisitor(visitor);
        }
    }

    public String processLiterals(String value) throws Exception {
        return new LiteralProcessingWidgetRoot(this, value).childHtml();
    }

    protected String expandVariables(String content) throws Exception {
        return new VariableExpandingWidgetRoot(this, content).childHtml();
    }

    protected String stripTrailingWhiteSpaceInLines(String value) {
        return Pattern.compile("[ \\t]+(\n)").matcher(value).replaceAll("$1");
    }

    public static class LiteralProcessingWidgetRoot
    extends ParentWidget {
        public LiteralProcessingWidgetRoot(ParentWidget parent, String content) throws Exception {
            super(parent);
            if (content != null) {
                this.addChildWidgets(content);
            }
        }

        @Override
        public String childHtml() throws Exception {
            StringBuffer html = new StringBuffer();
            while (this.hasNextChild()) {
                WikiWidget child = this.nextChild();
                if (child.getClass() == TextWidget.class) {
                    TextWidget tw = (TextWidget)child;
                    html.append(tw.getRawText());
                    continue;
                }
                html.append(child.render());
            }
            return html.toString();
        }

        @Override
        public WidgetBuilder getBuilder() {
            return preprocessingLiteralWidgetBuilder;
        }

        @Override
        public boolean doEscaping() {
            return false;
        }

        @Override
        public String render() throws Exception {
            return "";
        }

        @Override
        protected void addToParent() {
        }
    }
}

