/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fit.Counts;
import fit.FitProtocol;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystemListener;
import java.io.OutputStream;
import java.net.Socket;
import util.StreamReader;

public class FitClient {
    protected TestSystemListener listener;
    protected Socket fitSocket;
    private OutputStream fitInput;
    private StreamReader fitOutput;
    private volatile int sent = 0;
    private volatile int received = 0;
    private volatile boolean isDoneSending = false;
    protected volatile boolean killed = false;
    protected Thread fitListeningThread;

    public FitClient(TestSystemListener listener) throws Exception {
        this.listener = listener;
    }

    public void acceptSocket(Socket socket) throws Exception {
        this.checkForPulse();
        this.fitSocket = socket;
        this.fitInput = this.fitSocket.getOutputStream();
        FitProtocol.writeData("", this.fitInput);
        this.fitOutput = new StreamReader(this.fitSocket.getInputStream());
        this.fitListeningThread = new Thread((Runnable)new FitListeningRunnable(), "FitClient fitOutput");
        this.fitListeningThread.start();
    }

    public void send(String data) throws Exception {
        this.checkForPulse();
        FitProtocol.writeData(data, this.fitInput);
        ++this.sent;
    }

    public void done() throws Exception {
        this.checkForPulse();
        FitProtocol.writeSize(0, this.fitInput);
        this.isDoneSending = true;
    }

    public void join() throws Exception {
        if (this.fitListeningThread != null) {
            this.fitListeningThread.join();
        }
    }

    public void kill() throws Exception {
        this.killed = true;
        if (this.fitListeningThread != null) {
            this.fitListeningThread.interrupt();
        }
    }

    public void exceptionOccurred(Exception e) {
        this.listener.exceptionOccurred(e);
    }

    protected void checkForPulse() throws InterruptedException {
        if (this.killed) {
            throw new InterruptedException("FitClient was killed");
        }
    }

    private void listenToFit() {
        try {
            this.attemptToListenToFit();
        }
        catch (Exception e) {
            this.exceptionOccurred(e);
        }
    }

    private void attemptToListenToFit() throws Exception {
        while (!this.finishedReading()) {
            int size = FitProtocol.readSize(this.fitOutput);
            if (size != 0) {
                String readValue = this.fitOutput.read(size);
                if (this.fitOutput.byteCount() < size) {
                    throw new Exception("I was expecting " + size + " bytes but I only got " + this.fitOutput.byteCount());
                }
                this.listener.acceptOutputFirst(readValue);
                continue;
            }
            Counts counts = FitProtocol.readCounts(this.fitOutput);
            TestSummary summary = new TestSummary();
            summary.right = counts.right;
            summary.wrong = counts.wrong;
            summary.ignores = counts.ignores;
            summary.exceptions = counts.exceptions;
            this.listener.testComplete(summary);
            ++this.received;
        }
    }

    private boolean finishedReading() {
        while (this.stateIndeterminate()) {
            this.shortSleep();
        }
        return this.isDoneSending && this.received == this.sent;
    }

    private boolean stateIndeterminate() {
        return this.received == this.sent && !this.isDoneSending;
    }

    private void shortSleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class FitListeningRunnable
    implements Runnable {
        private FitListeningRunnable() {
        }

        @Override
        public void run() {
            FitClient.this.listenToFit();
        }
    }
}

