/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.RequestBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.StreamReader;

public class ResponseParser {
    private int status;
    private String body;
    private HashMap<String, String> headers = new HashMap();
    private StreamReader input;
    private static final Pattern statusLinePattern = Pattern.compile("HTTP/\\d.\\d (\\d\\d\\d) ");
    private static final Pattern headerPattern = Pattern.compile("([^:]*): (.*)");

    public ResponseParser(InputStream input) throws Exception {
        this.input = new StreamReader(input);
        this.parseStatusLine();
        this.parseHeaders();
        if (this.isChuncked()) {
            this.parseChunks();
            this.parseHeaders();
        } else {
            this.parseBody();
        }
    }

    private boolean isChuncked() {
        String encoding = this.getHeader("Transfer-Encoding");
        return encoding != null && "chunked".equals(encoding.toLowerCase());
    }

    private void parseStatusLine() throws Exception {
        String statusLine = this.input.readLine();
        Matcher match = statusLinePattern.matcher(statusLine);
        if (!match.find()) {
            throw new Exception("Could not parse Response");
        }
        String status = match.group(1);
        this.status = Integer.parseInt(status);
    }

    private void parseHeaders() throws Exception {
        String line = this.input.readLine();
        while (!"".equals(line)) {
            Matcher match = headerPattern.matcher(line);
            if (match.find()) {
                String key = match.group(1);
                String value = match.group(2);
                this.headers.put(key, value);
            }
            line = this.input.readLine();
        }
    }

    private void parseBody() throws Exception {
        String lengthHeader = "Content-Length";
        if (this.hasHeader(lengthHeader)) {
            int bytesToRead = Integer.parseInt(this.getHeader(lengthHeader));
            this.body = this.input.read(bytesToRead);
        }
    }

    private void parseChunks() throws Exception {
        StringBuffer bodyBuffer = new StringBuffer();
        int chunkSize = this.readChunkSize();
        while (chunkSize != 0) {
            bodyBuffer.append(this.input.read(chunkSize));
            this.readCRLF();
            chunkSize = this.readChunkSize();
        }
        this.body = bodyBuffer.toString();
    }

    private int readChunkSize() throws Exception {
        String sizeLine = this.input.readLine();
        return Integer.parseInt(sizeLine, 16);
    }

    private void readCRLF() throws Exception {
        this.input.read(2);
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return this.body;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public boolean hasHeader(String key) {
        return this.headers.containsKey(key);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Status: ").append(this.status).append("\n");
        buffer.append("Headers: ").append("\n");
        for (String key : this.headers.keySet()) {
            buffer.append("\t").append(key).append(": ").append(this.headers.get(key)).append("\n");
        }
        buffer.append("Body: ").append("\n");
        buffer.append(this.body);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseParser performHttpRequest(String hostname, int hostPort, RequestBuilder builder) throws Exception {
        Socket socket = new Socket(hostname, hostPort);
        OutputStream socketOut = socket.getOutputStream();
        InputStream socketIn = socket.getInputStream();
        builder.send(socketOut);
        socketOut.flush();
        try {
            ResponseParser responseParser = new ResponseParser(socketIn);
            return responseParser;
        }
        finally {
            socketOut.close();
            socket.close();
        }
    }
}

