/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.components.ClassPathBuilder;
import fitnesse.html.SetupTeardownAndLibraryIncluder;
import fitnesse.responders.run.PageListSetUpTearDownSurrounder;
import fitnesse.responders.run.PagesByTestSystem;
import fitnesse.responders.run.ResultsListener;
import fitnesse.responders.run.Stoppable;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.TestSystemGroup;
import fitnesse.responders.run.TestSystemListener;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import util.TimeMeasurement;

public class MultipleTestsRunner
implements TestSystemListener,
Stoppable {
    private final ResultsListener resultsListener;
    private final FitNesseContext fitNesseContext;
    private final WikiPage page;
    private final List<WikiPage> testPagesToRun;
    private boolean isFastTest = false;
    private boolean isRemoteDebug = false;
    private LinkedList<WikiPage> processingQueue = new LinkedList();
    private WikiPage currentTest = null;
    private TestSystemGroup testSystemGroup = null;
    private TestSystem currentTestSystem = null;
    private boolean isStopped = false;
    private String stopId = null;
    private PageListSetUpTearDownSurrounder surrounder;
    TimeMeasurement currentTestTime;
    TimeMeasurement totalTestTime;

    public MultipleTestsRunner(List<WikiPage> testPagesToRun, FitNesseContext fitNesseContext, WikiPage page, ResultsListener resultsListener) {
        this.testPagesToRun = testPagesToRun;
        this.resultsListener = resultsListener;
        this.page = page;
        this.fitNesseContext = fitNesseContext;
        this.surrounder = new PageListSetUpTearDownSurrounder(fitNesseContext.root);
    }

    public void setDebug(boolean isDebug) {
        this.isRemoteDebug = isDebug;
    }

    public void setFastTest(boolean isFastTest) {
        this.isFastTest = isFastTest;
    }

    public void executeTestPages() {
        try {
            this.internalExecuteTestPages();
            this.allTestingComplete();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            this.exceptionOccurred(exception);
        }
    }

    void allTestingComplete() throws Exception {
        TimeMeasurement completionTimeMeasurement = new TimeMeasurement().start();
        this.resultsListener.allTestingComplete(this.totalTestTime.stop());
        completionTimeMeasurement.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalExecuteTestPages() throws Exception {
        MultipleTestsRunner multipleTestsRunner = this;
        synchronized (multipleTestsRunner) {
            this.testSystemGroup = new TestSystemGroup(this.fitNesseContext, this.page, this);
            this.stopId = this.fitNesseContext.runningTestingTracker.addStartedProcess(this);
        }
        this.testSystemGroup.setFastTest(this.isFastTest);
        this.testSystemGroup.setManualStart(this.useManualStartForTestSystem());
        this.resultsListener.setExecutionLogAndTrackingId(this.stopId, this.testSystemGroup.getExecutionLog());
        PagesByTestSystem pagesByTestSystem = this.makeMapOfPagesByTestSystem();
        this.announceTotalTestsToRun(pagesByTestSystem);
        for (TestSystem.Descriptor descriptor : pagesByTestSystem.keySet()) {
            this.executePagesInTestSystem(descriptor, pagesByTestSystem);
        }
        this.fitNesseContext.runningTestingTracker.removeEndedProcess(this.stopId);
    }

    private boolean useManualStartForTestSystem() {
        if (this.isRemoteDebug) {
            try {
                String useManualStart = this.page.getData().getVariable("MANUALLY_START_TEST_RUNNER_ON_DEBUG");
                return useManualStart != null && useManualStart.toLowerCase().equals("true");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void executePagesInTestSystem(TestSystem.Descriptor descriptor, PagesByTestSystem pagesByTestSystem) throws Exception {
        List pagesInTestSystem = (List)pagesByTestSystem.get(descriptor);
        this.startTestSystemAndExecutePages(descriptor, pagesInTestSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTestSystemAndExecutePages(TestSystem.Descriptor descriptor, List<WikiPage> testSystemPages) throws Exception {
        TestSystem testSystem = null;
        MultipleTestsRunner multipleTestsRunner = this;
        synchronized (multipleTestsRunner) {
            if (!this.isStopped) {
                testSystem = this.currentTestSystem = this.testSystemGroup.startTestSystem(descriptor, this.buildClassPath());
                this.resultsListener.testSystemStarted(testSystem, descriptor.testSystemName, descriptor.testRunner);
            }
        }
        if (testSystem != null) {
            if (!testSystem.isSuccessfullyStarted()) {
                throw new Exception("Test system not started");
            }
            this.executeTestSystemPages(testSystemPages, testSystem);
            this.waitForTestSystemToSendResults();
            multipleTestsRunner = this;
            synchronized (multipleTestsRunner) {
                if (!this.isStopped) {
                    testSystem.bye();
                }
                this.currentTestSystem = null;
            }
        }
    }

    private void executeTestSystemPages(List<WikiPage> pagesInTestSystem, TestSystem testSystem) throws Exception {
        for (WikiPage testPage : pagesInTestSystem) {
            this.addToProcessingQueue(testPage);
            PageData pageData = testPage.getData();
            SetupTeardownAndLibraryIncluder.includeSetupsTeardownsAndLibrariesBelowTheSuite(pageData, this.page);
            testSystem.runTestsAndGenerateHtml(pageData);
        }
    }

    void addToProcessingQueue(WikiPage testPage) {
        this.processingQueue.addLast(testPage);
    }

    private void waitForTestSystemToSendResults() throws InterruptedException {
        while (this.processingQueue.size() > 0 && this.isNotStopped()) {
            Thread.sleep(50L);
        }
    }

    PagesByTestSystem makeMapOfPagesByTestSystem() throws Exception {
        return this.addSuiteSetUpAndTearDownToAllTestSystems(this.mapWithAllPagesButSuiteSetUpAndTearDown());
    }

    private PagesByTestSystem mapWithAllPagesButSuiteSetUpAndTearDown() throws Exception {
        PagesByTestSystem pagesByTestSystem = new PagesByTestSystem();
        for (WikiPage testPage : this.testPagesToRun) {
            if (SuiteContentsFinder.isSuiteSetupOrTearDown(testPage)) continue;
            this.addPageToListWithinMap(pagesByTestSystem, testPage);
        }
        return pagesByTestSystem;
    }

    private void addPageToListWithinMap(PagesByTestSystem pagesByTestSystem, WikiPage testPage) throws Exception {
        TestSystem.Descriptor descriptor = TestSystem.getDescriptor(testPage.getData(), this.isRemoteDebug);
        this.getOrMakeListWithinMap(pagesByTestSystem, descriptor).add(testPage);
    }

    private LinkedList<WikiPage> getOrMakeListWithinMap(PagesByTestSystem pagesByTestSystem, TestSystem.Descriptor descriptor) {
        LinkedList pagesForTestSystem;
        if (!pagesByTestSystem.containsKey(descriptor)) {
            pagesForTestSystem = new LinkedList();
            pagesByTestSystem.put(descriptor, pagesForTestSystem);
        } else {
            pagesForTestSystem = (LinkedList)pagesByTestSystem.get(descriptor);
        }
        return pagesForTestSystem;
    }

    private PagesByTestSystem addSuiteSetUpAndTearDownToAllTestSystems(PagesByTestSystem pagesByTestSystem) throws Exception {
        if (this.testPagesToRun.size() == 0) {
            return pagesByTestSystem;
        }
        for (LinkedList pagesForTestSystem : pagesByTestSystem.values()) {
            this.surrounder.surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns(pagesForTestSystem);
        }
        return pagesByTestSystem;
    }

    void announceTotalTestsToRun(PagesByTestSystem pagesByTestSystem) {
        int tests = 0;
        for (LinkedList listOfPagesToRun : pagesByTestSystem.values()) {
            tests += listOfPagesToRun.size();
        }
        this.resultsListener.announceNumberTestsToRun(tests);
        this.totalTestTime = new TimeMeasurement().start();
    }

    public String buildClassPath() throws Exception {
        ClassPathBuilder classPathBuilder = new ClassPathBuilder();
        String pathSeparator = classPathBuilder.getPathSeparator(this.page);
        ArrayList<String> classPathElements = new ArrayList<String>();
        HashSet<WikiPage> visitedPages = new HashSet<WikiPage>();
        for (WikiPage testPage : this.testPagesToRun) {
            this.addClassPathElements(testPage, classPathElements, visitedPages);
        }
        return classPathBuilder.createClassPathString(classPathElements, pathSeparator);
    }

    private void addClassPathElements(WikiPage page, List<String> classPathElements, Set<WikiPage> visitedPages) throws Exception {
        List<String> pathElements = new ClassPathBuilder().getInheritedPathElements(page, visitedPages);
        classPathElements.addAll(pathElements);
    }

    @Override
    public void acceptOutputFirst(String output) throws Exception {
        boolean isNewTest;
        WikiPage firstInQueue = this.processingQueue.isEmpty() ? null : this.processingQueue.getFirst();
        boolean bl = isNewTest = firstInQueue != null && firstInQueue != this.currentTest;
        if (isNewTest) {
            this.startingNewTest(firstInQueue);
        }
        this.resultsListener.testOutputChunk(output);
    }

    void startingNewTest(WikiPage test) throws Exception {
        this.currentTest = test;
        this.currentTestTime = new TimeMeasurement().start();
        this.resultsListener.newTestStarted(this.currentTest, this.currentTestTime);
    }

    @Override
    public void testComplete(TestSummary testSummary) throws Exception {
        WikiPage testPage = this.processingQueue.removeFirst();
        this.resultsListener.testComplete(testPage, testSummary, this.currentTestTime.stop());
    }

    @Override
    public void exceptionOccurred(Throwable e) {
        block2: {
            try {
                this.resultsListener.errorOccured();
                this.stop();
            }
            catch (Exception e1) {
                if (!this.isNotStopped()) break block2;
                e1.printStackTrace();
            }
        }
    }

    private synchronized boolean isNotStopped() {
        return !this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        boolean wasNotStopped = this.isNotStopped();
        MultipleTestsRunner multipleTestsRunner = this;
        synchronized (multipleTestsRunner) {
            this.isStopped = true;
            if (this.stopId != null) {
                this.fitNesseContext.runningTestingTracker.removeEndedProcess(this.stopId);
            }
        }
        if (wasNotStopped) {
            this.testSystemGroup.kill();
        }
    }
}

