/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureTestOperation;
import fitnesse.http.Response;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.run.JavaFormatter;
import fitnesse.responders.run.MultipleTestsRunner;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.responders.run.TestEventListener;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.CompositeFormatter;
import fitnesse.responders.run.formatters.PageHistoryFormatter;
import fitnesse.responders.run.formatters.PageInProgressFormatter;
import fitnesse.responders.run.formatters.TestHtmlFormatter;
import fitnesse.responders.run.formatters.TestTextFormatter;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public class TestResponder
extends ChunkingResponder
implements SecureResponder {
    private static LinkedList<TestEventListener> eventListeners = new LinkedList();
    protected PageData data;
    protected CompositeFormatter formatters = new CompositeFormatter();
    private boolean isClosed = false;
    private boolean fastTest = false;
    private boolean remoteDebug = false;
    protected TestSystem testSystem;

    @Override
    protected void doSending() throws Exception {
        this.checkArguments();
        this.data = this.page.getData();
        this.createFormatterAndWriteHead();
        this.sendPreTestNotification();
        this.performExecution();
        int exitCode = this.formatters.getErrorCount();
        this.closeHtmlResponse(exitCode);
    }

    protected void checkArguments() {
        this.fastTest |= this.request.hasInput("debug");
        this.remoteDebug |= this.request.hasInput("remote_debug");
    }

    protected void createFormatterAndWriteHead() throws Exception {
        if (this.response.isXmlFormat()) {
            this.addXmlFormatter();
        } else if (this.response.isTextFormat()) {
            this.addTextFormatter();
        } else if (this.response.isJavaFormat()) {
            this.addJavaFormatter();
        } else {
            this.addHtmlFormatter();
        }
        if (!this.request.hasInput("nohistory")) {
            this.addTestHistoryFormatter();
        }
        this.addTestInProgressFormatter();
        this.formatters.writeHead(this.getTitle());
    }

    String getTitle() {
        return "Test Results";
    }

    void addXmlFormatter() throws Exception {
        XmlFormatter.WriterFactory writerSource = new XmlFormatter.WriterFactory(){

            @Override
            public Writer getWriter(FitNesseContext context, WikiPage page, TestSummary counts, long time) {
                return TestResponder.this.makeResponseWriter();
            }
        };
        this.formatters.add(new XmlFormatter(this.context, this.page, writerSource));
    }

    void addTextFormatter() {
        this.formatters.add(new TestTextFormatter(this.response));
    }

    void addJavaFormatter() throws Exception {
        this.formatters.add(JavaFormatter.getInstance(new WikiPagePath(this.page).toString()));
    }

    protected Writer makeResponseWriter() {
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                String fragment = new String(cbuf, off, len);
                try {
                    TestResponder.this.response.add(fragment.getBytes());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    void addHtmlFormatter() throws Exception {
        TestHtmlFormatter formatter = new TestHtmlFormatter(this.context, this.page, this.context.htmlPageFactory){

            @Override
            protected void writeData(String output) throws Exception {
                TestResponder.this.addToResponse(output);
            }
        };
        this.formatters.add(formatter);
    }

    protected void addTestHistoryFormatter() throws Exception {
        HistoryWriterFactory writerFactory = new HistoryWriterFactory();
        this.formatters.add(new PageHistoryFormatter(this.context, this.page, writerFactory));
    }

    protected void addTestInProgressFormatter() throws Exception {
        this.formatters.add(new PageInProgressFormatter(this.page));
    }

    protected void sendPreTestNotification() throws Exception {
        for (TestEventListener eventListener : eventListeners) {
            eventListener.notifyPreTest(this, this.data);
        }
    }

    protected void performExecution() throws Exception {
        List<WikiPage> test2run = new SuiteContentsFinder(this.page, null, this.root).makePageListForSingleTest();
        MultipleTestsRunner runner = new MultipleTestsRunner(test2run, this.context, this.page, this.formatters);
        runner.setFastTest(this.fastTest);
        runner.setDebug(this.isRemoteDebug());
        if (this.isEmpty(this.page)) {
            this.formatters.addMessageForBlankHtml();
        }
        runner.executeTestPages();
    }

    private boolean isEmpty(WikiPage page) throws Exception {
        return page.getData().getContent().length() == 0;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureTestOperation();
    }

    public static void registerListener(TestEventListener listener) {
        eventListeners.add(listener);
    }

    public void setFastTest(boolean fastTest) {
        this.fastTest = fastTest;
    }

    public boolean isFastTest() {
        return this.fastTest;
    }

    public void addToResponse(byte[] output) throws Exception {
        if (!this.isClosed()) {
            this.response.add(output);
        }
    }

    public void addToResponse(String output) throws Exception {
        if (!this.isClosed()) {
            this.response.add(output);
        }
    }

    synchronized boolean isClosed() {
        return this.isClosed;
    }

    synchronized void setClosed() {
        this.isClosed = true;
    }

    void closeHtmlResponse(int exitCode) throws Exception {
        if (!this.isClosed()) {
            this.setClosed();
            this.response.closeChunks();
            this.response.addTrailingHeader("Exit-Code", String.valueOf(exitCode));
            this.response.closeTrailer();
            this.response.close();
        }
    }

    void closeHtmlResponse() throws Exception {
        if (!this.isClosed()) {
            this.setClosed();
            this.response.closeChunks();
            this.response.close();
        }
    }

    boolean isRemoteDebug() {
        return this.remoteDebug;
    }

    public Response getResponse() {
        return this.response;
    }

    public static class HistoryWriterFactory
    implements XmlFormatter.WriterFactory {
        @Override
        public Writer getWriter(FitNesseContext context, WikiPage page, TestSummary counts, long time) throws Exception {
            File resultPath = new File(PageHistory.makePageHistoryFileName(context, page, counts, time));
            File resultDirectory = new File(resultPath.getParent());
            resultDirectory.mkdirs();
            File resultFile = new File(resultDirectory, resultPath.getName());
            return new FileWriter(resultFile);
        }
    }
}

