/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.VelocityFactory;
import fitnesse.responders.run.formatters.SuiteExecutionReportFormatter;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.wiki.WikiPage;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import util.TimeMeasurement;

public class SuiteHistoryFormatter
extends SuiteExecutionReportFormatter {
    private Writer writer;
    private XmlFormatter.WriterFactory writerFactory;
    private long suiteTime = 0L;

    public SuiteHistoryFormatter(FitNesseContext context, WikiPage page, Writer writer) throws Exception {
        super(context, page);
        this.writer = writer;
    }

    @Override
    public void newTestStarted(WikiPage test, TimeMeasurement timeMeasurement) throws Exception {
        if (this.suiteTime == 0L) {
            this.suiteTime = timeMeasurement.startedAt();
        }
        super.newTestStarted(test, timeMeasurement);
    }

    public SuiteHistoryFormatter(FitNesseContext context, WikiPage page, XmlFormatter.WriterFactory source) throws Exception {
        super(context, page);
        this.writerFactory = source;
    }

    @Override
    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws Exception {
        super.allTestingComplete(totalTimeMeasurement);
        if (this.writerFactory != null) {
            this.writer = this.writerFactory.getWriter(this.context, this.page, this.getPageCounts(), this.suiteTime);
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("suiteExecutionReport", this.suiteExecutionReport);
        VelocityEngine velocityEngine = VelocityFactory.getVelocityEngine();
        Template template = velocityEngine.getTemplate("suiteHistoryXML.vm");
        template.merge(velocityContext, this.writer);
        this.writer.close();
    }
}

