/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageType;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.parser.Comment;
import fitnesse.wikitext.parser.Define;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Include;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Paths;
import fitnesse.wikitext.parser.Preformat;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Variable;
import fitnesse.wikitext.parser.VariableFinder;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.widgets.TextIgnoringWidgetRoot;
import fitnesse.wikitext.widgets.WidgetWithTextArgument;
import fitnesse.wikitext.widgets.XRefWidget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import util.Clock;
import util.Maybe;
import util.StringUtil;

public class PageData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static WidgetBuilder xrefWidgetBuilder = new WidgetBuilder(XRefWidget.class);
    private static SymbolProvider variableDefinitionSymbolProvider = new SymbolProvider(new SymbolType[]{Literal.symbolType, new Define(), new Include(), SymbolType.CloseLiteral, Comment.symbolType, SymbolType.Whitespace, SymbolType.Newline, Variable.symbolType, Preformat.symbolType, SymbolType.ClosePreformat, SymbolType.Text});
    public static final String PropertyLAST_MODIFIED = "LastModified";
    public static final String PropertyHELP = "Help";
    public static final String PropertyPRUNE = "Prune";
    public static final String PropertySEARCH = "Search";
    public static final String PropertyRECENT_CHANGES = "RecentChanges";
    public static final String PropertyFILES = "Files";
    public static final String PropertyWHERE_USED = "WhereUsed";
    public static final String PropertyREFACTOR = "Refactor";
    public static final String PropertyPROPERTIES = "Properties";
    public static final String PropertyVERSIONS = "Versions";
    public static final String PropertyEDIT = "Edit";
    public static final String PropertySUITES = "Suites";
    public static final String PAGE_TYPE_ATTRIBUTE = "PageType";
    public static final String[] PAGE_TYPE_ATTRIBUTES = new String[]{PageType.STATIC.toString(), PageType.TEST.toString(), PageType.SUITE.toString()};
    public static final String[] ACTION_ATTRIBUTES = new String[]{"Edit", "Versions", "Properties", "Refactor", "WhereUsed"};
    public static final String[] NAVIGATION_ATTRIBUTES = new String[]{"RecentChanges", "Files", "Search"};
    public static final String[] NON_SECURITY_ATTRIBUTES = StringUtil.combineArrays(ACTION_ATTRIBUTES, NAVIGATION_ATTRIBUTES);
    public static final String PropertySECURE_READ = "secure-read";
    public static final String PropertySECURE_WRITE = "secure-write";
    public static final String PropertySECURE_TEST = "secure-test";
    public static final String[] SECURITY_ATTRIBUTES = new String[]{"secure-read", "secure-write", "secure-test"};
    public static final String LAST_MODIFYING_USER = "LastModifyingUser";
    public static final String SUITE_SETUP_NAME = "SuiteSetUp";
    public static final String SUITE_TEARDOWN_NAME = "SuiteTearDown";
    private transient WikiPage wikiPage;
    private String content;
    private WikiPageProperties properties = new WikiPageProperties();
    private Set<VersionInfo> versions;
    public static final String COMMAND_PATTERN = "COMMAND_PATTERN";
    public static final String TEST_RUNNER = "TEST_RUNNER";
    public static final String PATH_SEPARATOR = "PATH_SEPARATOR";
    private Symbol contentSyntaxTree = null;
    private ParsingPage parsingPage;

    public PageData(WikiPage page) throws Exception {
        this.wikiPage = page;
        this.initializeAttributes();
        this.versions = new HashSet<VersionInfo>();
    }

    public PageData(WikiPage page, String content) throws Exception {
        this(page);
        this.setContent(content);
    }

    public PageData(PageData data) throws Exception {
        this(data.getWikiPage(), data.content);
        this.properties = new WikiPageProperties(data.properties);
        this.versions.addAll(data.versions);
        this.contentSyntaxTree = data.contentSyntaxTree;
        this.parsingPage = data.parsingPage;
    }

    public void initializeAttributes() throws Exception {
        this.properties.set(PropertyEDIT, Boolean.toString(true));
        this.properties.set(PropertyVERSIONS, Boolean.toString(true));
        this.properties.set(PropertyPROPERTIES, Boolean.toString(true));
        this.properties.set(PropertyREFACTOR, Boolean.toString(true));
        this.properties.set(PropertyWHERE_USED, Boolean.toString(true));
        this.properties.set(PropertyFILES, Boolean.toString(true));
        this.properties.set(PropertyRECENT_CHANGES, Boolean.toString(true));
        this.properties.set(PropertySEARCH, Boolean.toString(true));
        this.properties.setLastModificationTime(Clock.currentDate());
        this.initTestOrSuiteProperty();
    }

    private void initTestOrSuiteProperty() throws Exception {
        String pageName = this.wikiPage.getName();
        if (pageName == null) {
            this.handleInvalidPageName(this.wikiPage);
            return;
        }
        if (this.isErrorLogsPage()) {
            return;
        }
        PageType pageType = PageType.getPageTypeForPageName(pageName);
        if (PageType.STATIC.equals((Object)pageType)) {
            return;
        }
        this.properties.set(pageType.toString(), Boolean.toString(true));
    }

    private boolean isErrorLogsPage() throws Exception {
        PageCrawler crawler = this.wikiPage.getPageCrawler();
        String relativePagePath = crawler.getRelativeName(crawler.getRoot(this.wikiPage), this.wikiPage);
        return relativePagePath.startsWith("ErrorLogs");
    }

    private void handleInvalidPageName(WikiPage wikiPage) {
        try {
            String msg = "WikiPage " + wikiPage + " does not have a valid name!" + wikiPage.getName();
            System.err.println(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public WikiPageProperties getProperties() throws Exception {
        return this.properties;
    }

    public String getAttribute(String key) throws Exception {
        return this.properties.get(key);
    }

    public void removeAttribute(String key) throws Exception {
        this.properties.remove(key);
    }

    public void setAttribute(String key, String value) throws Exception {
        this.properties.set(key, value);
    }

    public void setAttribute(String key) throws Exception {
        this.properties.set(key);
    }

    public boolean hasAttribute(String attribute) {
        return this.properties.has(attribute);
    }

    public void setProperties(WikiPageProperties properties) {
        this.properties = properties;
    }

    public String getContent() throws Exception {
        return StringUtil.stripCarriageReturns(this.content);
    }

    public void setContent(String content) {
        this.content = content;
        this.contentSyntaxTree = null;
        this.parsingPage = null;
    }

    public String getHtml() throws Exception {
        return this.translateToHtml(this.getSyntaxTree());
    }

    public String getHeaderPageHtml() throws Exception {
        WikiPage header = this.wikiPage.getHeaderPage();
        return header == null ? "" : header.getData().getHtml();
    }

    public String getFooterPageHtml() throws Exception {
        WikiPage footer = this.wikiPage.getFooterPage();
        return footer == null ? "" : footer.getData().getHtml();
    }

    public String getVariable(String name) throws Exception {
        Maybe<String> variable = new VariableFinder(this.getParsingPage()).findVariable(name);
        if (variable.isNothing()) {
            return null;
        }
        return new HtmlTranslator(null, this.parsingPage).translate(Parser.make(this.parsingPage, "${" + name + "}", variableDefinitionSymbolProvider).parse());
    }

    public Symbol getSyntaxTree() throws Exception {
        this.parsePageContent();
        return this.contentSyntaxTree;
    }

    public ParsingPage getParsingPage() throws Exception {
        this.parsePageContent();
        return this.parsingPage;
    }

    private void parsePageContent() throws Exception {
        if (this.contentSyntaxTree == null) {
            this.parsingPage = new ParsingPage(new WikiSourcePage(this.wikiPage));
            this.contentSyntaxTree = Parser.make(this.parsingPage, this.getContent()).parse();
        }
    }

    public void addVariable(String name, String value) throws Exception {
        this.getParsingPage().putVariable(name, value);
    }

    public void setLiterals(List<String> literals) {
    }

    public String translateToHtml(Symbol syntaxTree) {
        return new HtmlTranslator(new WikiSourcePage(this.wikiPage), this.parsingPage).translateTree(syntaxTree);
    }

    public void setWikiPage(WikiPage page) {
        this.wikiPage = page;
    }

    public WikiPage getWikiPage() {
        return this.wikiPage;
    }

    public List<String> getClasspaths() throws Exception {
        Symbol tree = this.getSyntaxTree();
        return new Paths(new HtmlTranslator(new WikiSourcePage(this.wikiPage), this.parsingPage)).getPaths(tree);
    }

    public List<String> getXrefPages() throws Exception {
        return this.getTextOfWidgets(xrefWidgetBuilder);
    }

    private List<String> getTextOfWidgets(WidgetBuilder builder) throws Exception {
        TextIgnoringWidgetRoot root = new TextIgnoringWidgetRoot(this.getContent(), this.wikiPage, builder);
        List<WikiWidget> widgets = root.getChildren();
        ArrayList<String> values = new ArrayList<String>();
        for (WikiWidget widget : widgets) {
            if (widget instanceof WidgetWithTextArgument) {
                values.add(((WidgetWithTextArgument)((Object)widget)).getText());
                continue;
            }
            widget.render();
        }
        return values;
    }

    public Set<VersionInfo> getVersions() {
        return this.versions;
    }

    public void addVersions(Collection<VersionInfo> newVersions) {
        this.versions.addAll(newVersions);
    }

    public boolean isEmpty() throws Exception {
        return this.getContent() == null || this.getContent().length() == 0;
    }
}

