/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import util.StringUtil;

public class WikiPageProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String value;
    protected HashMap<String, WikiPageProperty> children;

    public WikiPageProperty() {
    }

    public WikiPageProperty(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringUtil.trimNonNullString(value);
    }

    public void set(String name, WikiPageProperty child) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        this.children.put(name, child);
    }

    public WikiPageProperty set(String name, String value) {
        WikiPageProperty child = new WikiPageProperty(value);
        this.set(name, child);
        return child;
    }

    public WikiPageProperty set(String name) {
        return this.set(name, (String)null);
    }

    public void remove(String name) {
        this.children.remove(name);
    }

    public WikiPageProperty getProperty(String name) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(name);
    }

    public String get(String name) {
        WikiPageProperty child = this.getProperty(name);
        return child == null ? null : child.getValue();
    }

    public boolean has(String name) {
        return this.children != null && this.children.containsKey(name);
    }

    public Set<String> keySet() {
        return this.children == null ? new HashSet() : this.children.keySet();
    }

    public String toString() {
        return this.toString("WikiPageProperty root", 0);
    }

    protected String toString(String key, int depth) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            buffer.append("\t");
        }
        buffer.append(key);
        if (this.getValue() != null) {
            buffer.append(" = ").append(this.getValue());
        }
        buffer.append("\n");
        for (String childKey : this.keySet()) {
            WikiPageProperty value = this.getProperty(childKey);
            if (value == null) continue;
            buffer.append(value.toString(childKey, depth + 1));
        }
        return buffer.toString();
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public static SimpleDateFormat getTimeFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }
}

