/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import util.StreamReader;
import util.StringUtil;

public class FileUtil {
    public static final String ENDL = System.getProperty("line.separator");

    public static File createFile(String path, String content) {
        String[] names = path.split("/");
        if (names.length == 1) {
            return FileUtil.createFile(new File(path), content);
        }
        File parent = null;
        for (int i = 0; i < names.length - 1; ++i) {
            File file = parent = parent == null ? new File(names[i]) : new File(parent, names[i]);
            if (parent.exists()) continue;
            parent.mkdir();
        }
        File fileToCreate = new File(parent, names[names.length - 1]);
        return FileUtil.createFile(fileToCreate, content);
    }

    public static File createFile(File file, String content) {
        FileOutputStream fileOutput = null;
        try {
            fileOutput = new FileOutputStream(file);
            fileOutput.write(content.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileOutput != null) {
                try {
                    fileOutput.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public static boolean makeDir(String path) {
        return new File(path).mkdir();
    }

    public static void deleteFileSystemDirectory(String dirPath) {
        FileUtil.deleteFileSystemDirectory(new File(dirPath));
    }

    public static void deleteFileSystemDirectory(File current) {
        File[] files = current.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtil.deleteFileSystemDirectory(file);
                continue;
            }
            FileUtil.deleteFile(file);
        }
        FileUtil.deleteFile(current);
    }

    public static void deleteFile(String filename) {
        FileUtil.deleteFile(new File(filename));
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete()) {
                FileUtil.waitUntilFileDeleted(file);
                return;
            }
            FileUtil.waitFor(10);
        }
        throw new RuntimeException("Could not delete '" + file.getAbsoluteFile() + "'");
    }

    private static void waitUntilFileDeleted(File file) {
        int i = 10;
        while (file.exists()) {
            if (--i <= 0) {
                System.out.println("Breaking out of delete wait");
                break;
            }
            FileUtil.waitFor(500);
        }
    }

    private static void waitFor(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getFileContent(String path) throws Exception {
        File input = new File(path);
        return FileUtil.getFileContent(input);
    }

    public static String getFileContent(File input) throws Exception {
        return new String(FileUtil.getFileBytes(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileBytes(File input) throws Exception {
        long size = input.length();
        FileInputStream stream = null;
        try {
            byte[] bytes;
            stream = new FileInputStream(input);
            byte[] byArray = bytes = new StreamReader(stream).readBytes((int)size);
            return byArray;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static LinkedList<String> getFileLines(String filename) throws Exception {
        return FileUtil.getFileLines(new File(filename));
    }

    public static LinkedList<String> getFileLines(File file) throws Exception {
        String line;
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        reader.close();
        return lines;
    }

    public static void writeLinesToFile(String filename, List<?> lines) throws Exception {
        FileUtil.writeLinesToFile(new File(filename), lines);
    }

    public static void writeLinesToFile(File file, List<?> lines) throws Exception {
        PrintStream output = new PrintStream(new FileOutputStream(file));
        for (String line : lines) {
            output.println(line);
        }
        output.close();
    }

    public static void copyBytes(InputStream input, OutputStream output) throws Exception {
        StreamReader reader = new StreamReader(input);
        while (!reader.isEof()) {
            output.write(reader.readBytes(1000));
        }
    }

    public static File createDir(String path) {
        FileUtil.makeDir(path);
        return new File(path);
    }

    public static File[] getDirectoryListing(File dir) {
        TreeSet<File> dirSet = new TreeSet<File>();
        TreeSet<File> fileSet = new TreeSet<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return new File[0];
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                dirSet.add(files[i]);
                continue;
            }
            fileSet.add(files[i]);
        }
        LinkedList<File> fileList = new LinkedList<File>();
        fileList.addAll(dirSet);
        fileList.addAll(fileSet);
        return fileList.toArray(new File[0]);
    }

    public static String buildPath(String[] parts) {
        return StringUtil.join(Arrays.asList(parts), System.getProperty("file.separator"));
    }

    public static List<String> breakFilenameIntoParts(String fileName) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(fileName.split("/")));
        return parts;
    }

    public static String getPathOfFile(String fileName) {
        List<String> parts = FileUtil.breakFilenameIntoParts(fileName);
        parts.remove(parts.size() - 1);
        return FileUtil.buildPath(parts.toArray(new String[parts.size()]));
    }

    public static void addItemsToClasspath(String classpathItems) throws Exception {
        String[] items;
        String separator = System.getProperty("path.separator");
        String currentClassPath = System.getProperty("java.class.path");
        System.setProperty("java.class.path", currentClassPath + separator + classpathItems);
        for (String item : items = classpathItems.split(separator)) {
            FileUtil.addFileToClassPath(item);
        }
    }

    private static void addFileToClassPath(String fileName) throws Exception {
        FileUtil.addUrlToClasspath(new File(fileName).toURI().toURL());
    }

    public static void addUrlToClasspath(URL u) throws Exception {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, u);
    }
}

