/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSSynchronizationPolicy;
import org.firebirdsql.gds.GDSType;
import org.firebirdsql.ngds.GDS_Impl;

public class GDSFactory {
    private static final Map gdsTypeToGdsInstanceMap = new HashMap();

    public static GDS getDefaultGDS() {
        return GDSFactory.getGDSForType(GDSType.PURE_JAVA);
    }

    public static synchronized GDS getGDSForType(GDSType gdsType) {
        GDS gds = (GDS)gdsTypeToGdsInstanceMap.get(gdsType);
        if (gds == null) {
            gds = GDSFactory.createGDSForType(gdsType);
            gds = GDSSynchronizationPolicy.applySyncronizationPolicy(gds, gdsType);
            gdsTypeToGdsInstanceMap.put(gdsType, gds);
        }
        return gds;
    }

    private static GDS createGDSForType(GDSType gdsType) {
        if (gdsType == GDSType.PURE_JAVA) {
            return new org.firebirdsql.jgds.GDS_Impl();
        }
        if (gdsType == GDSType.NATIVE) {
            return new GDS_Impl(gdsType);
        }
        if (gdsType == GDSType.NATIVE_LOCAL) {
            return new GDS_Impl(gdsType);
        }
        if (gdsType == GDSType.NATIVE_EMBEDDED) {
            return new GDS_Impl(gdsType);
        }
        if (gdsType == GDSType.ORACLE_MODE) {
            return new GDS_Impl(gdsType);
        }
        throw new IllegalArgumentException("gdsType not recognized.");
    }
}

