/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeGraphLayout<N, E>
extends GraphLayout {
    private GraphScene<N, E> scene;
    private int originX;
    private int originY;
    private int verticalGap;
    private int horizontalGap;
    private boolean vertical;

    public TreeGraphLayout(GraphScene<N, E> scene, int originX, int originY, int verticalGap, int horizontalGap, boolean vertical) {
        this.scene = scene;
        this.originX = originX;
        this.originY = originY;
        this.verticalGap = verticalGap;
        this.horizontalGap = horizontalGap;
        this.vertical = vertical;
    }

    public final void layout(N rootNode) {
        if (rootNode == null) {
            return;
        }
        Collection<N> allNodes = this.scene.getNodes();
        ArrayList<N> nodesToResolve = new ArrayList<N>(allNodes);
        HashSet loadedSet = new HashSet();
        Node root = new Node(rootNode, loadedSet);
        nodesToResolve.removeAll(loadedSet);
        if (this.vertical) {
            root.allocateHorizontally();
            root.resolveVertically(this.originX, this.originY);
        } else {
            root.allocateVertically();
            root.resolveHorizontally(this.originX, this.originY);
        }
        HashMap<N, Point> resultPosition = new HashMap<N, Point>();
        root.upload(resultPosition);
        for (N n : nodesToResolve) {
            Point position = new Point();
            resultPosition.put(n, position);
        }
        for (Map.Entry entry : resultPosition.entrySet()) {
            this.scene.findWidget(entry.getKey()).setPreferredLocation((Point)entry.getValue());
        }
    }

    protected Collection<N> resolveChildren(N node) {
        Collection<E> edges = this.scene.findNodeEdges(node, true, false);
        HashSet<N> nodes = new HashSet<N>();
        for (E edge : edges) {
            nodes.add(this.scene.getEdgeTarget(edge));
        }
        return nodes;
    }

    protected void performGraphLayout(UniversalGraph graph) {
        Collection<N> allNodes = this.scene.getNodes();
        ArrayList<N> rootNodes = new ArrayList<N>();
        for (N node : allNodes) {
            Collection<E> inputEdges = this.scene.findNodeEdges(node, false, true);
            if (inputEdges != null && inputEdges.size() != 0) continue;
            rootNodes.add(node);
        }
        for (Object rootNode : rootNodes) {
            this.layout(rootNode);
        }
    }

    protected void performNodesLayout(UniversalGraph graph, Collection nodes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        private N node;
        private ArrayList<Node> children;
        private Rectangle relativeBounds;
        private int space;
        private int totalSpace;
        private Point point;

        private Node(N node, HashSet<N> loadedSet) {
            this.node = node;
            loadedSet.add(node);
            Collection list = TreeGraphLayout.this.resolveChildren(node);
            this.children = new ArrayList();
            for (Object child : list) {
                if (loadedSet.contains(child)) continue;
                this.children.add(new Node(child, loadedSet));
            }
        }

        private int allocateHorizontally() {
            Widget widget = TreeGraphLayout.this.scene.findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayout.this.horizontalGap;
                }
                this.space += this.children.get(i).allocateHorizontally();
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.width);
            return this.totalSpace;
        }

        private void resolveVertically(int x, int y) {
            this.point = new Point(x + this.totalSpace / 2, y - this.relativeBounds.y);
            x += (this.totalSpace - this.space) / 2;
            y += this.relativeBounds.height + TreeGraphLayout.this.verticalGap;
            for (Node child : this.children) {
                child.resolveVertically(x, y);
                x += child.totalSpace + TreeGraphLayout.this.horizontalGap;
            }
        }

        private int allocateVertically() {
            Widget widget = TreeGraphLayout.this.scene.findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayout.this.verticalGap;
                }
                this.space += this.children.get(i).allocateVertically();
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.height);
            return this.totalSpace;
        }

        private void resolveHorizontally(int x, int y) {
            this.point = new Point(x - this.relativeBounds.x, y + this.totalSpace / 2);
            x += this.relativeBounds.width + TreeGraphLayout.this.horizontalGap;
            y += (this.totalSpace - this.space) / 2;
            for (Node child : this.children) {
                child.resolveHorizontally(x, y);
                y += child.totalSpace + TreeGraphLayout.this.verticalGap;
            }
        }

        private void upload(HashMap<N, Point> result) {
            result.put(this.node, this.point);
            for (Node child : this.children) {
                child.upload(result);
            }
        }
    }
}

