/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.DualGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTPlanarizer {
    private final int DEFAULT_ITERATIONS = 1;
    private int maxIterations = 1;
    private boolean isRandom = false;
    private Random random = new Random();

    public Collection<EmbeddedPlanarGraph> planarize(MGraph graph) {
        Collection<EmbeddedPlanarGraph> epgs = this.createPlanarSubgraphs(graph);
        return epgs;
    }

    private Collection<EmbeddedPlanarGraph> createPlanarSubgraphs(MGraph graph) {
        ArrayList<MGraph.Edge> LMax = null;
        ArrayList<MGraph.Edge> RMax = null;
        ArrayList<MGraph.Edge> BMax = null;
        ArrayList<MGraph.Vertex> orderingMax = null;
        for (int i = 0; i < this.maxIterations; ++i) {
            ArrayList<MGraph.Edge> L = new ArrayList<MGraph.Edge>();
            ArrayList<MGraph.Edge> R = new ArrayList<MGraph.Edge>();
            ArrayList<MGraph.Edge> B = new ArrayList<MGraph.Edge>();
            ArrayList<MGraph.Vertex> ordering = this.computeOrdering(graph.getVertices());
            this.computeLRB(L, R, B, ordering);
            if (LMax != null && L.size() + R.size() <= LMax.size() + RMax.size()) continue;
            LMax = L;
            RMax = R;
            BMax = B;
            orderingMax = ordering;
        }
        int order = 0;
        for (MGraph.Vertex v : orderingMax) {
            v.setNumber(order++);
        }
        LinkedHashSet<Face> leftFaces = new LinkedHashSet<Face>();
        LinkedHashSet<Face> rightFaces = new LinkedHashSet<Face>();
        Collection<ArrayList<Face>> faceLists = this.createAllFaces(LMax, RMax, orderingMax, leftFaces, rightFaces);
        ArrayList<EmbeddedPlanarGraph> epgs = new ArrayList<EmbeddedPlanarGraph>();
        for (ArrayList<Face> faceList : faceLists) {
            EmbeddedPlanarGraph epg = EmbeddedPlanarGraph.createGraph(graph);
            epgs.add(epg);
            epg.addFaces(faceList);
        }
        this.insertRemainingEdges(epgs, BMax, rightFaces, false, leftFaces, new HashSet<MGraph.Edge>(LMax));
        return epgs;
    }

    private ArrayList<MGraph.Vertex> computeOrdering(Collection<MGraph.Vertex> vertices) {
        ArrayList<MGraph.Vertex> ordering = new ArrayList<MGraph.Vertex>();
        ArrayList<MGraph.Vertex> vertexArray = new ArrayList<MGraph.Vertex>(vertices);
        int order = 0;
        MGraph.Vertex v = this.getMinimumDegreeVertex(vertexArray);
        this.assignOrdering(ordering, v, order++);
        vertexArray.remove(v);
        ArrayList<MGraph.Vertex> candidates = new ArrayList<MGraph.Vertex>();
        while (!vertexArray.isEmpty()) {
            Collection<MGraph.Vertex> neighbors = v.getNeighbors();
            for (MGraph.Vertex nv : neighbors) {
                if (!vertexArray.contains(nv)) continue;
                candidates.add(nv);
            }
            v = this.getMinimumDegreeVertex(candidates);
            if (v == null) {
                v = vertexArray.get(0);
            }
            this.assignOrdering(ordering, v, order++);
            vertexArray.remove(v);
            candidates.clear();
        }
        return ordering;
    }

    private MGraph.Vertex getMinimumDegreeVertex(Collection<MGraph.Vertex> vertices) {
        if (vertices.size() == 0) {
            return null;
        }
        ArrayList<MGraph.Vertex> candidates = new ArrayList<MGraph.Vertex>();
        int minDegree = this.getMinimumDegree(vertices);
        for (MGraph.Vertex v : vertices) {
            if (v.getDegree() != minDegree) continue;
            candidates.add(v);
        }
        return this.pickVertex(candidates);
    }

    private int getMinimumDegree(Collection<MGraph.Vertex> vertices) {
        int minDegree = Integer.MAX_VALUE;
        for (MGraph.Vertex v : vertices) {
            int degree = v.getDegree();
            if (degree >= minDegree) continue;
            minDegree = degree;
        }
        return minDegree;
    }

    private MGraph.Vertex pickVertex(ArrayList<MGraph.Vertex> candidates) {
        int index = 0;
        if (this.isRandom()) {
            index = this.random.nextInt(candidates.size());
        }
        return candidates.get(index);
    }

    private void computeLRB(ArrayList<MGraph.Edge> L, ArrayList<MGraph.Edge> R, ArrayList<MGraph.Edge> B, ArrayList<MGraph.Vertex> ordering) {
        int tmp;
        int jewo;
        int jevo;
        MGraph.Edge je;
        int j;
        int tmp2;
        int iewo;
        int ievo;
        MGraph.Edge ie;
        int i;
        ArrayList<MGraph.Edge> edges = this.assignEdgeWeights(ordering);
        int size = edges.size();
        for (i = 0; i < size; ++i) {
            ie = edges.get(i);
            if (R.contains(ie)) continue;
            ievo = ie.getV().getNumber();
            if (ievo > (iewo = ie.getW().getNumber())) {
                tmp2 = ievo;
                ievo = iewo;
                iewo = tmp2;
            }
            L.add(ie);
            for (j = i + 1; j < size; ++j) {
                je = edges.get(j);
                if (R.contains(je)) continue;
                jevo = je.getV().getNumber();
                if (jevo > (jewo = je.getW().getNumber())) {
                    tmp = jevo;
                    jevo = jewo;
                    jewo = tmp;
                }
                if ((ievo >= jevo || jevo >= iewo || iewo >= jewo) && (jevo >= ievo || ievo >= jewo || jewo >= iewo)) continue;
                R.add(je);
            }
        }
        size = R.size();
        for (i = 0; i < size; ++i) {
            ie = R.get(i);
            if (B.contains(ie)) continue;
            ievo = ie.getV().getNumber();
            if (ievo > (iewo = ie.getW().getNumber())) {
                tmp2 = ievo;
                ievo = iewo;
                iewo = tmp2;
            }
            for (j = i + 1; j < size; ++j) {
                je = R.get(j);
                if (B.contains(je)) continue;
                jevo = je.getV().getNumber();
                if (jevo > (jewo = je.getW().getNumber())) {
                    tmp = jevo;
                    jevo = jewo;
                    jewo = tmp;
                }
                if ((ievo >= jevo || jevo >= iewo || iewo >= jewo) && (jevo >= ievo || ievo >= jewo || jewo >= iewo)) continue;
                B.add(je);
            }
        }
        R.removeAll(B);
    }

    private ArrayList<MGraph.Edge> assignEdgeWeights(Collection<MGraph.Vertex> vertices) {
        LinkedHashSet<MGraph.Edge> edges = new LinkedHashSet<MGraph.Edge>();
        for (MGraph.Vertex v : vertices) {
            Collection<MGraph.Edge> localEdges = v.getEdges();
            for (MGraph.Edge e : localEdges) {
                edges.add(e);
            }
        }
        if (!this.isRandom) {
            return new ArrayList<MGraph.Edge>(edges);
        }
        int size = edges.size();
        for (MGraph.Edge e : edges) {
            e.setWeight(0);
        }
        ArrayList<MGraph.Edge> sortedEdges = new ArrayList<MGraph.Edge>(edges);
        for (int i = 0; i < size - 2; ++i) {
            MGraph.Edge ie = sortedEdges.get(i);
            for (int j = i + 1; j < size - 1; ++j) {
                MGraph.Edge je = sortedEdges.get(j);
                if (je.getWeight() >= ie.getWeight()) continue;
                sortedEdges.set(i, je);
                sortedEdges.set(j, ie);
                ie = je;
            }
        }
        return sortedEdges;
    }

    private void assignOrdering(ArrayList<MGraph.Vertex> ordering, MGraph.Vertex v, int order) {
        ordering.add(v);
        v.setNumber(order);
    }

    private Collection<ArrayList<Face>> createAllFaces(Collection<MGraph.Edge> L, Collection<MGraph.Edge> R, ArrayList<MGraph.Vertex> ordering, Collection<Face> leftFaces, Collection<Face> rightFaces) {
        ArrayList<Face> faces = new ArrayList<Face>();
        leftFaces.addAll(this.createFaces(L, null, ordering, false));
        rightFaces.addAll(this.createFaces(R, L, ordering, true));
        faces.addAll(leftFaces);
        faces.addAll(rightFaces);
        this.removeFaces(faces);
        Collection<ArrayList<Face>> faceLists = this.computeFaceLists(faces);
        for (ArrayList<Face> faceList : faceLists) {
            Face outerFace = this.createOuterFace(faceList, L, R);
            faceList.add(0, outerFace);
            rightFaces.add(outerFace);
            leftFaces.add(outerFace);
        }
        return faceLists;
    }

    private Collection<ArrayList<Face>> computeFaceLists(ArrayList<Face> faces) {
        ArrayList<ArrayList<Face>> faceLists = new ArrayList<ArrayList<Face>>();
        faces = new ArrayList<Face>(faces);
        while (!faces.isEmpty()) {
            ArrayList<Face> faceList = new ArrayList<Face>();
            faceLists.add(faceList);
            Face firstFace = faces.remove(0);
            faceList.add(firstFace);
            for (int i = 0; i < faceList.size(); ++i) {
                ArrayList<Face> connectedFaces = new ArrayList<Face>();
                Face iface = (Face)faceList.get(i);
                for (int j = 0; j < faces.size(); ++j) {
                    Face jface = faces.get(j);
                    if (!iface.connects(jface)) continue;
                    connectedFaces.add(jface);
                }
                faces.removeAll(connectedFaces);
                faceList.addAll(connectedFaces);
            }
        }
        return faceLists;
    }

    private Face createOuterFace(ArrayList<Face> faces, Collection<MGraph.Edge> L, Collection<MGraph.Edge> R) {
        HashSet<MGraph.Edge> sharedEdges = new HashSet<MGraph.Edge>();
        LinkedHashSet<Face.Dart> outerDarts = new LinkedHashSet<Face.Dart>();
        HashSet<MGraph.Edge> outerEdges = new HashSet<MGraph.Edge>();
        ArrayList<Face.Dart> reverseDarts = new ArrayList<Face.Dart>();
        HashSet<MGraph.Edge> reverseEdges = new HashSet<MGraph.Edge>();
        HashSet<MGraph.Edge> leftEdges = new HashSet<MGraph.Edge>(L);
        int size = faces.size();
        MGraph.Edge firstDart = null;
        for (int i = 0; i < size; ++i) {
            Face f = faces.get(i);
            for (Face.Dart d : f.getDarts()) {
                MGraph.Edge e = d.getEdge();
                boolean isSharedEdge = false;
                if (sharedEdges.contains(e)) continue;
                for (int j = i + 1; j < size; ++j) {
                    Face nf = faces.get(j);
                    if (!nf.containsEdge(e)) continue;
                    sharedEdges.add(e);
                    isSharedEdge = true;
                    break;
                }
                if (isSharedEdge) continue;
                if (firstDart == null) {
                    firstDart = d;
                    outerEdges.add(e);
                    continue;
                }
                if (!outerEdges.contains(e)) {
                    outerDarts.add(d);
                    outerEdges.add(e);
                    continue;
                }
                reverseDarts.add(d);
                reverseEdges.add(d.getEdge());
            }
        }
        outerDarts.addAll(reverseDarts);
        Face outerFace = new Face();
        outerFace.setOuterFace(true);
        MGraph.Vertex v = firstDart.getV();
        outerDarts.remove(firstDart);
        outerFace.addEdge(((Face.Dart)firstDart).getEdge());
        ArrayList<Face.Dart> candidateDarts = new ArrayList<Face.Dart>();
        while (!outerDarts.isEmpty()) {
            candidateDarts.clear();
            int vNumber = v.getNumber();
            for (Face.Dart d : outerDarts) {
                if (!d.contains(v)) continue;
                candidateDarts.add(d);
            }
            Face.Dart nextDart = null;
            if (candidateDarts.size() > 1) {
                for (Face.Dart cd : candidateDarts) {
                    if (!reverseEdges.contains(cd.getEdge())) continue;
                    reverseEdges.remove(cd.getEdge());
                    nextDart = cd;
                    break;
                }
                if (nextDart == null) {
                    for (Face.Dart cd : candidateDarts) {
                        if (!R.contains(cd.getEdge())) continue;
                        nextDart = cd;
                        break;
                    }
                }
                if (nextDart == null) {
                    for (Face.Dart cd : candidateDarts) {
                        if (nextDart == null) {
                            nextDart = cd;
                            continue;
                        }
                        MGraph.Vertex cw = null;
                        cw = cd.getW().getNumber() > cd.getV().getNumber() ? cd.getW() : cd.getV();
                        MGraph.Vertex nw = null;
                        nw = nextDart.getW().getNumber() > nextDart.getV().getNumber() ? nextDart.getW() : nextDart.getV();
                        int cNumber = cw.getNumber();
                        int nNumber = nw.getNumber();
                        if (cNumber <= vNumber || cNumber >= nNumber) continue;
                        nextDart = cd;
                    }
                }
            } else {
                nextDart = candidateDarts.size() > 0 ? (Face.Dart)candidateDarts.get(0) : null;
            }
            if (nextDart == null) continue;
            outerDarts.remove(nextDart);
            outerFace.addEdge(nextDart.getEdge());
            v = nextDart.getOppositeVertex(v);
        }
        outerFace.setOuterFace(true);
        outerFace.createDarts();
        return outerFace;
    }

    private Collection<Face> createFaces(Collection<MGraph.Edge> subgraph, Collection<MGraph.Edge> alternateSubgraph, ArrayList<MGraph.Vertex> ordering, boolean reverseDirection) {
        ArrayList<Face> faces = new ArrayList<Face>();
        block0: for (MGraph.Vertex v : ordering) {
            Collection<MGraph.Edge> connEdges = this.getIncidentEdges(v, subgraph);
            while (!connEdges.isEmpty()) {
                int maxOrder = v.getNumber();
                MGraph.Edge maxEdge = null;
                for (MGraph.Edge e : connEdges) {
                    MGraph.Vertex w = e.getOppositeVertex(v);
                    int order = w.getNumber();
                    if (order <= maxOrder) continue;
                    maxOrder = order;
                    maxEdge = e;
                }
                if (maxEdge == null) continue block0;
                connEdges.remove(maxEdge);
                Collection<MGraph.Edge> shortestPath = this.computeShortedReturnPath(v, maxEdge.getOppositeVertex(v), maxEdge, subgraph, alternateSubgraph);
                if (shortestPath.isEmpty()) continue;
                Face face = new Face();
                face.addEdge(maxEdge);
                face.addEdges(shortestPath);
                boolean invalidFace = false;
                if (face.getDegree() == 2) {
                    for (Face f : faces) {
                        if (!face.borders(f)) continue;
                        invalidFace = true;
                        break;
                    }
                }
                if (invalidFace) continue;
                if (reverseDirection) {
                    face.reverseDirection();
                }
                face.createDarts();
                faces.add(face);
            }
        }
        return faces;
    }

    private Collection<MGraph.Edge> computeShortedReturnPath(MGraph.Vertex sourceVertex, MGraph.Vertex currentVertex, MGraph.Edge currentEdge, Collection<MGraph.Edge> edges, Collection<MGraph.Edge> alternateEdges) {
        ArrayList<MGraph.Edge> result = new ArrayList<MGraph.Edge>();
        Collection<MGraph.Edge> connEdges = this.getIncidentEdges(currentVertex, edges);
        connEdges.remove(currentEdge);
        int sourceOrder = sourceVertex.getNumber();
        int currentOrder = currentVertex.getNumber();
        MGraph.Edge edge = null;
        int minOrder = currentOrder;
        boolean lowerOrderFound = false;
        for (MGraph.Edge e : connEdges) {
            MGraph.Vertex w = e.getOppositeVertex(currentVertex);
            int order = w.getNumber();
            if (order < minOrder && order >= sourceOrder) {
                minOrder = order;
                edge = e;
            }
            if (order >= currentOrder) continue;
            lowerOrderFound = true;
        }
        if (edge == null && alternateEdges != null) {
            connEdges = this.getIncidentEdges(currentVertex, alternateEdges);
            int maxOrder = sourceOrder;
            for (MGraph.Edge e : connEdges) {
                MGraph.Vertex w = e.getOppositeVertex(currentVertex);
                int order = w.getNumber();
                if (order >= maxOrder && order < currentOrder) {
                    maxOrder = order;
                    edge = e;
                }
                if (order >= currentOrder) continue;
                lowerOrderFound = true;
            }
        }
        if (edge == null && !lowerOrderFound) {
            edge = currentEdge;
        }
        if (edge != null) {
            if (edge.contains(sourceVertex)) {
                result.add(edge);
            } else {
                Collection<MGraph.Edge> shortestPath = null;
                MGraph.Vertex oppositeVertex = edge.getOppositeVertex(currentVertex);
                if (!oppositeVertex.equals(currentVertex) || !edge.equals(currentEdge)) {
                    shortestPath = this.computeShortedReturnPath(sourceVertex, oppositeVertex, edge, edges, alternateEdges);
                }
                if (!shortestPath.isEmpty()) {
                    result.add(edge);
                    result.addAll(shortestPath);
                }
            }
        }
        return result;
    }

    private void removeFaces(Collection<Face> faces) {
        ArrayList<Face> facesToRemove = new ArrayList<Face>();
        for (Face f : faces) {
            if (f.isOuterFace() || f.getDegree() != 2) continue;
            for (Face nf : faces) {
                if (nf.isOuterFace() || f == nf || !f.borders(nf)) continue;
                facesToRemove.add(f);
            }
        }
        faces.removeAll(facesToRemove);
    }

    private Collection<MGraph.Edge> getIncidentEdges(MGraph.Vertex v, Collection<MGraph.Edge> edges) {
        ArrayList<MGraph.Edge> result = new ArrayList<MGraph.Edge>(v.getEdges());
        result.retainAll(edges);
        return result;
    }

    private void insertRemainingEdges(Collection<EmbeddedPlanarGraph> epgs, Collection<MGraph.Edge> edgesToInsert, Collection<Face> faces, boolean isLeftFaces, Collection<Face> facesToIgnore, Collection<MGraph.Edge> edgesToIgnore) {
        if (edgesToInsert.isEmpty()) {
            return;
        }
        for (EmbeddedPlanarGraph epg : epgs) {
            DualGraph dualGraph = DualGraph.createGraph(epg, facesToIgnore, edgesToIgnore);
            for (MGraph.Edge edge : edgesToInsert) {
                this.insertEdge(dualGraph, edge, faces, isLeftFaces);
            }
        }
    }

    private void insertEdge(DualGraph graph, MGraph.Edge edgeToInsert, Collection<Face> faces, boolean isLeftFaces) {
        EmbeddedPlanarGraph epg = graph.getOriginalGraph();
        MGraph originalGraph = epg.getOriginalGraph();
        MGraph.Vertex v = edgeToInsert.getV();
        MGraph.Vertex w = edgeToInsert.getW();
        boolean reverse = false;
        if (v.getNumber() < w.getNumber()) {
            reverse = true;
        }
        ArrayList<DualGraph.FaceEdge> shortestPath = this.computeShortestPathInDualGraph(graph, v, w, faces);
        DualGraph.FaceEdge fe = null;
        DualGraph.FaceVertex fv = null;
        MGraph.Vertex currentVertex = null;
        MGraph.Vertex prevVertex = v;
        MGraph.DummyEdge newEdge = null;
        MGraph.Edge prevEdge = null;
        ArrayList<MGraph.Edge> newFaceEdges = null;
        int length = shortestPath.size();
        for (int i = 0; i <= length; ++i) {
            if (i == length) {
                currentVertex = w;
            } else {
                fe = shortestPath.get(i);
                if (i == 0) {
                    fv = fe.getVertex(v);
                }
                if (newFaceEdges != null) {
                    fv.getFace().replaceEdge(prevEdge, newFaceEdges);
                }
                currentVertex = originalGraph.insertDummyVertex(fe.getEdge(), MGraph.DummyVertex.Type.CROSSING);
                ((MGraph.DummyVertex)currentVertex).setNumber(Integer.MAX_VALUE);
                newFaceEdges = new ArrayList<MGraph.Edge>(currentVertex.getEdges());
            }
            newEdge = originalGraph.addDummyEdge(prevVertex, currentVertex);
            newEdge.setOriginalEdge(edgeToInsert);
            MGraph.Vertex startingVertex = null;
            startingVertex = isLeftFaces ? (reverse ? currentVertex : prevVertex) : (reverse ? prevVertex : currentVertex);
            this.subdivide(graph, fv, fe, newFaceEdges, newEdge, startingVertex, faces);
            prevVertex = currentVertex;
            prevEdge = fe.getEdge();
            if (i >= length) continue;
            fv = fe.getOppositeVertex(fv);
        }
        this.removeFaces(epg.getFaces());
        graph.updateFaces();
        graph.updateEdges();
    }

    private Collection<DualGraph.FaceVertex> getIncidentFaceVertices(MGraph.Vertex v, DualGraph graph, Collection<Face> rightFaces) {
        LinkedHashSet<DualGraph.FaceVertex> result = new LinkedHashSet<DualGraph.FaceVertex>();
        DualGraph.FaceVertex outerFace = null;
        Collection<MGraph.Edge> edges = v.getEdges();
        for (MGraph.Edge e : edges) {
            Collection<DualGraph.FaceVertex> faceVertices = graph.getVerticesBorderingEdge(e);
            for (DualGraph.FaceVertex fv : faceVertices) {
                Face f = fv.getFace();
                if (!rightFaces.contains(f)) continue;
                if (f.isOuterFace()) {
                    outerFace = fv;
                    continue;
                }
                result.add(fv);
            }
        }
        if (result.isEmpty()) {
            result.add(outerFace);
        }
        return result;
    }

    private ArrayList<DualGraph.FaceEdge> computeShortestPathInDualGraph(DualGraph graph, MGraph.Vertex v, MGraph.Vertex w, Collection<Face> rightFaces) {
        EmbeddedPlanarGraph epg = graph.getOriginalGraph();
        Collection<DualGraph.FaceVertex> vFaceVertices = this.getIncidentFaceVertices(v, graph, rightFaces);
        Collection<DualGraph.FaceVertex> wFaceVertices = this.getIncidentFaceVertices(w, graph, rightFaces);
        ArrayList<DualGraph.FaceEdge> shortestPath = null;
        int shortestPathLength = Integer.MAX_VALUE;
        for (DualGraph.FaceVertex vfv : vFaceVertices) {
            for (DualGraph.FaceVertex wfv : wFaceVertices) {
                ArrayList<DualGraph.FaceEdge> path;
                if (vfv == wfv || (path = this.computeShortestPathInDualGraph(vfv, wfv, new HashSet<DualGraph.FaceVertex>(), shortestPathLength, rightFaces)) == null || shortestPath != null && path.size() >= shortestPath.size()) continue;
                shortestPath = path;
                shortestPathLength = shortestPath.size();
                if (shortestPath.size() != 1) continue;
                return shortestPath;
            }
        }
        return shortestPath;
    }

    private ArrayList<DualGraph.FaceEdge> computeShortestPathInDualGraph(DualGraph.FaceVertex sourceVertex, DualGraph.FaceVertex destVertex, Collection<DualGraph.FaceVertex> visitedVertices, int minPathLength, Collection<Face> faces) {
        ArrayList<DualGraph.FaceEdge> shortestPath = null;
        visitedVertices.add(sourceVertex);
        for (DualGraph.FaceEdge e : sourceVertex.getEdges()) {
            ArrayList<DualGraph.FaceEdge> path;
            if (e.contains(destVertex)) {
                shortestPath = new ArrayList<DualGraph.FaceEdge>();
                shortestPath.add(e);
                break;
            }
            DualGraph.FaceVertex oppositeVertex = e.getOppositeVertex(sourceVertex);
            if (!faces.contains(oppositeVertex.getFace()) || visitedVertices.contains(oppositeVertex) || visitedVertices.size() - 1 > minPathLength || (path = this.computeShortestPathInDualGraph(oppositeVertex, destVertex, visitedVertices, minPathLength, faces)) == null || shortestPath != null && path.size() >= shortestPath.size() - 1) continue;
            shortestPath = new ArrayList();
            shortestPath.add(e);
            shortestPath.addAll(path);
            minPathLength = shortestPath.size();
        }
        visitedVertices.remove(sourceVertex);
        return shortestPath;
    }

    public void subdivide(DualGraph graph, DualGraph.FaceVertex fv, DualGraph.FaceEdge fe, Collection<MGraph.Edge> newFaceEdges, MGraph.Edge dividingEdge, MGraph.Vertex startingVertex, Collection<Face> faces) {
        Face face = fv.getFace();
        face.replaceEdge(fe.getEdge(), newFaceEdges);
        List<Face.Dart> removedDarts = face.replaceDarts(dividingEdge, startingVertex);
        Face newFace = new Face();
        MGraph.Edge firstDart = null;
        for (Face.Dart d : removedDarts) {
            if (firstDart == null) {
                firstDart = d;
            }
            newFace.addEdge(d.getEdge());
        }
        newFace.addEdge(dividingEdge);
        newFace.createDarts(firstDart.getV());
        EmbeddedPlanarGraph epg = graph.getOriginalGraph();
        epg.addFace(newFace);
        faces.add(newFace);
        graph.updateFaces();
    }

    public void setRandom(boolean flag) {
        this.isRandom = flag;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public void setMaxIterations(int iterations) {
        this.maxIterations = iterations;
    }

    private int getMaxIterations() {
        return this.maxIterations;
    }
}

