/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionWidgetLayout
implements Layout {
    private ConnectionWidget connectionWidget;
    private HashMap<Widget, LayoutFactory.ConnectionWidgetLayoutAlignment> alignments;
    private HashMap<Widget, Float> percentagePlacements;
    private HashMap<Widget, Integer> distancePlacements;

    public ConnectionWidgetLayout(ConnectionWidget connectionWidget) {
        this.connectionWidget = connectionWidget;
    }

    public void setConstraint(Widget childWidget, LayoutFactory.ConnectionWidgetLayoutAlignment alignment, float placementInPercentage) {
        assert (childWidget != null);
        assert (alignment != null);
        if (this.alignments == null) {
            this.alignments = new HashMap();
        }
        this.alignments.put(childWidget, alignment);
        if (this.percentagePlacements == null) {
            this.percentagePlacements = new HashMap();
        }
        this.percentagePlacements.put(childWidget, Float.valueOf(placementInPercentage));
        if (this.distancePlacements != null) {
            this.distancePlacements.remove(childWidget);
        }
    }

    public void setConstraint(Widget childWidget, LayoutFactory.ConnectionWidgetLayoutAlignment alignment, int placementAtDistance) {
        assert (childWidget != null);
        assert (alignment != null);
        if (this.alignments == null) {
            this.alignments = new HashMap();
        }
        this.alignments.put(childWidget, alignment);
        if (this.percentagePlacements != null) {
            this.percentagePlacements.remove(childWidget);
        }
        if (this.distancePlacements == null) {
            this.distancePlacements = new HashMap();
        }
        this.distancePlacements.put(childWidget, placementAtDistance);
    }

    public void removeConstraint(Widget childWidget) {
        assert (childWidget != null);
        if (this.alignments != null) {
            this.alignments.remove(childWidget);
        }
        if (this.percentagePlacements != null) {
            this.percentagePlacements.remove(childWidget);
        }
        if (this.distancePlacements != null) {
            this.distancePlacements.remove(childWidget);
        }
    }

    @Override
    public void layout(Widget widget) {
        assert (this.connectionWidget == widget);
        this.connectionWidget.calculateRouting();
        List<Point> controlPoints = this.connectionWidget.getControlPoints();
        boolean empty = controlPoints == null || controlPoints.size() <= 0;
        double totalDistance = 0.0;
        double[] distances = new double[empty ? 0 : controlPoints.size() - 1];
        for (int i = 0; i < distances.length; ++i) {
            distances[i] = totalDistance += GeomUtil.distanceSq(controlPoints.get(i), controlPoints.get(i + 1));
        }
        for (Widget child : widget.getChildren()) {
            Integer distance;
            Float percentage = this.percentagePlacements != null ? this.percentagePlacements.get(child) : null;
            Integer n = distance = this.distancePlacements != null ? this.distancePlacements.get(child) : null;
            if (empty) {
                this.layoutChildAt(child, new Point());
                continue;
            }
            if (percentage != null) {
                if ((double)percentage.floatValue() <= 0.0) {
                    this.layoutChildAt(child, this.connectionWidget.getFirstControlPoint());
                    continue;
                }
                if ((double)percentage.floatValue() >= 1.0) {
                    this.layoutChildAt(child, this.connectionWidget.getLastControlPoint());
                    continue;
                }
                this.layoutChildAtDistance(distances, (int)((double)percentage.floatValue() * totalDistance), child, controlPoints);
                continue;
            }
            if (distance != null) {
                if (distance < 0) {
                    this.layoutChildAtDistance(distances, distance + (int)totalDistance, child, controlPoints);
                    continue;
                }
                this.layoutChildAtDistance(distances, distance, child, controlPoints);
                continue;
            }
            this.layoutChildAt(child, new Point());
        }
    }

    @Override
    public boolean requiresJustification(Widget widget) {
        return false;
    }

    @Override
    public void justify(Widget widget) {
    }

    private void layoutChildAtDistance(double[] distances, int lineDistance, Widget child, List<Point> controlPoints) {
        int index = distances.length - 1;
        for (int i = 0; i < distances.length; ++i) {
            if (!((double)lineDistance < distances[i])) continue;
            index = i;
            break;
        }
        double segmentStartDistance = index > 0 ? distances[index - 1] : 0.0;
        double segmentLength = distances[index] - segmentStartDistance;
        double segmentDistance = (double)lineDistance - segmentStartDistance;
        if (segmentLength == 0.0) {
            this.layoutChildAt(child, controlPoints.get(index));
            return;
        }
        Point p1 = controlPoints.get(index);
        Point p2 = controlPoints.get(index + 1);
        double segmentFactor = segmentDistance / segmentLength;
        this.layoutChildAt(child, new Point((int)((double)p1.x + (double)(p2.x - p1.x) * segmentFactor), (int)((double)p1.y + (double)(p2.y - p1.y) * segmentFactor)));
    }

    private void layoutChildAt(Widget childWidget, Point linePoint) {
        if (!childWidget.isVisible()) {
            childWidget.resolveBounds(new Point(linePoint.x, linePoint.y), new Rectangle());
            return;
        }
        Rectangle preferredBounds = childWidget.getPreferredBounds();
        LayoutFactory.ConnectionWidgetLayoutAlignment alignment = null;
        if (this.alignments != null) {
            alignment = this.alignments.get(childWidget);
        }
        if (alignment == null) {
            alignment = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        }
        Point referencePoint = this.getReferencePoint(alignment, preferredBounds);
        Point location = childWidget.getPreferredLocation();
        if (location != null) {
            referencePoint.translate(-location.x, -location.y);
        }
        childWidget.resolveBounds(new Point(linePoint.x - referencePoint.x, linePoint.y - referencePoint.y), preferredBounds);
    }

    private Point getReferencePoint(LayoutFactory.ConnectionWidgetLayoutAlignment alignment, Rectangle rectangle) {
        LayoutFactory.ConnectionWidgetLayoutAlignment adjusted = this.adjustAlignment(alignment);
        switch (adjusted) {
            case BOTTOM_CENTER: {
                return new Point(GeomUtil.centerX(rectangle), rectangle.y - 1);
            }
            case BOTTOM_LEFT: {
                return new Point(rectangle.x + rectangle.width, rectangle.y - 1);
            }
            case BOTTOM_RIGHT: {
                return new Point(rectangle.x - 1, rectangle.y - 1);
            }
            case CENTER: {
                return GeomUtil.center(rectangle);
            }
            case CENTER_LEFT: {
                return new Point(rectangle.x + rectangle.width, GeomUtil.centerY(rectangle));
            }
            case CENTER_RIGHT: {
                return new Point(rectangle.x - 1, GeomUtil.centerY(rectangle));
            }
            case NONE: {
                return new Point();
            }
            case TOP_CENTER: {
                return new Point(GeomUtil.centerX(rectangle), rectangle.y + rectangle.height);
            }
            case TOP_LEFT: {
                return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            }
            case TOP_RIGHT: {
                return new Point(rectangle.x - 1, rectangle.y + rectangle.height);
            }
        }
        return new Point();
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment adjustAlignment(LayoutFactory.ConnectionWidgetLayoutAlignment alignment) {
        LayoutFactory.ConnectionWidgetLayoutAlignment retVal = alignment;
        if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_SOURCE) {
            Point sourcePt = this.connectionWidget.getFirstControlPoint();
            Rectangle sourceBounds = this.getSourceBounds();
            retVal = this.calculateBestCenterAlignment(sourcePt, sourceBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_TARGET) {
            Point targetPt = this.connectionWidget.getLastControlPoint();
            Rectangle targetBounds = this.getTargetBounds();
            retVal = this.calculateBestCenterAlignment(targetPt, targetBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_SOURCE) {
            Point sourcePt = this.connectionWidget.getFirstControlPoint();
            Rectangle sourceBounds = this.getSourceBounds();
            retVal = this.calculateBestBottomAlignment(sourcePt, sourceBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_TARGET) {
            Point targetPt = this.connectionWidget.getLastControlPoint();
            Rectangle targetBounds = this.getTargetBounds();
            retVal = this.calculateBestBottomAlignment(targetPt, targetBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_SOURCE) {
            Point sourcePt = this.connectionWidget.getFirstControlPoint();
            Rectangle sourceBounds = this.getSourceBounds();
            retVal = this.calculateBestTopAlignment(sourcePt, sourceBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_TARGET) {
            Point targetPt = this.connectionWidget.getLastControlPoint();
            Rectangle targetBounds = this.getTargetBounds();
            retVal = this.calculateBestTopAlignment(targetPt, targetBounds);
        }
        return retVal;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestCenterAlignment(Point point, Rectangle bounds) {
        LayoutFactory.ConnectionWidgetLayoutAlignment retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (bounds != null) {
            if (point.x <= bounds.x) {
                retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_LEFT;
            } else if (point.x >= bounds.x + bounds.width) {
                retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_RIGHT;
            } else if (point.y <= bounds.y) {
                retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_CENTER;
            } else if (point.y >= bounds.y + bounds.height) {
                retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_CENTER;
            }
        }
        return retVal;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestBottomAlignment(Point point, Rectangle bounds) {
        LayoutFactory.ConnectionWidgetLayoutAlignment retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (point.x <= bounds.x) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_LEFT;
        } else if (point.x >= bounds.x + bounds.width) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_RIGHT;
        } else if (point.y <= bounds.y) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT;
        } else if (point.y >= bounds.y + bounds.height) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_LEFT;
        }
        return retVal;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestTopAlignment(Point point, Rectangle bounds) {
        LayoutFactory.ConnectionWidgetLayoutAlignment retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (point.x <= bounds.x) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT;
        } else if (point.x >= bounds.x + bounds.width) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT;
        } else if (point.y <= bounds.y) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT;
        } else if (point.y >= bounds.y + bounds.height) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_RIGHT;
        }
        return retVal;
    }

    private Rectangle getSourceBounds() {
        Widget source = this.connectionWidget.getSourceAnchor().getRelatedWidget();
        if (source != null) {
            Point sourceLocation = source.getLocation();
            Rectangle clientArea = source.getClientArea();
            return new Rectangle(sourceLocation, clientArea.getSize());
        }
        return null;
    }

    private Rectangle getTargetBounds() {
        Widget target = this.connectionWidget.getTargetAnchor().getRelatedWidget();
        if (target != null) {
            Point targetLocation = target.getLocation();
            Rectangle targetArea = target.getClientArea();
            return new Rectangle(targetLocation, targetArea.getSize());
        }
        return null;
    }
}

