/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.scope.internal.OperaMouseKeys;
import com.opera.core.systems.scope.services.Exec;
import org.openqa.selenium.Point;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.internal.Coordinates;

public class OperaMouse
implements Mouse {
    private final Exec exec;
    private Point lastMousePosition;

    public OperaMouse(OperaDriver parent) {
        this.exec = parent.getScopeServices().getExec();
    }

    @Override
    public void click(Coordinates where) {
        Point p = this.getPoint(where, "click");
        this.exec.mouseAction(p.x, p.y, OperaMouseKeys.LEFT);
    }

    @Override
    public void contextClick(Coordinates where) {
        Point p = this.getPoint(where, "context click");
        this.exec.mouseAction(p.x, p.y, OperaMouseKeys.RIGHT);
    }

    @Override
    public void doubleClick(Coordinates where) {
        Point p = this.getPoint(where, "double click");
        this.exec.mouseAction(p.x, p.y, 2, OperaMouseKeys.LEFT);
    }

    public void tripleClick(Coordinates where) {
        Point p = this.getPoint(where, "triple click");
        this.exec.mouseAction(p.x, p.y, 3, OperaMouseKeys.LEFT);
    }

    public void quadrupleClick(Coordinates where) {
        Point p = this.getPoint(where, "quadruple click");
        this.exec.mouseAction(p.x, p.y, 4, OperaMouseKeys.LEFT);
    }

    @Override
    public void mouseDown(Coordinates where) {
        Point p = this.getPoint(where, "mouse down");
        this.exec.mouseAction(p.x, p.y, OperaMouseKeys.LEFT_DOWN);
    }

    @Override
    public void mouseUp(Coordinates where) {
        Point p = this.getPoint(where, "mouse up");
        this.exec.mouseAction(p.x, p.y, OperaMouseKeys.LEFT_UP);
    }

    @Override
    public void mouseMove(Coordinates where) {
        Point p = this.getPoint(where, "mouse move");
        this.exec.mouseAction(p.x, p.y, new OperaMouseKeys[0]);
    }

    @Override
    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        Point p = this.getPoint(where, "mouse move");
        int xO = (int)xOffset;
        int yO = (int)yOffset;
        this.lastMousePosition = new Point(p.x + xO, p.y + yO);
        this.exec.mouseAction(p.x + xO, p.y + yO, new OperaMouseKeys[0]);
    }

    private Point getPoint(Coordinates where, String action) {
        if (where != null) {
            this.lastMousePosition = where.inViewPort();
        }
        if (this.lastMousePosition != null) {
            return this.lastMousePosition;
        }
        throw new InvalidCoordinatesException("Invalid coordinates to " + action + " on");
    }
}

