/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.security.Principal;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.SSORealm;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.Credential;

public class HashSSORealm
implements SSORealm {
    private static Log log = LogFactory.getLog(HashSSORealm.class);
    public static final String SSO_COOKIE_NAME = "SSO_ID";
    private HashMap _ssoId2Principal = new HashMap();
    private HashMap _ssoUsername2Id = new HashMap();
    private HashMap _ssoPrincipal2Credential = new HashMap();
    private transient Random _random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credential getSingleSignOn(HttpRequest request, HttpResponse response) {
        String ssoID = null;
        Cookie[] cookies = request.getCookies();
        int i = 0;
        while (i < cookies.length) {
            if (cookies[i].getName().equals(SSO_COOKIE_NAME)) {
                ssoID = cookies[i].getValue();
                break;
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug("get ssoID=" + ssoID);
        }
        Principal principal = null;
        Credential credential = null;
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            principal = (Principal)this._ssoId2Principal.get(ssoID);
            credential = (Credential)this._ssoPrincipal2Credential.get(principal);
        }
        if (log.isDebugEnabled()) {
            log.debug("SSO principal=" + principal);
        }
        if (principal != null && credential != null) {
            if (response.getHttpContext().getRealm().reauthenticate(principal)) {
                request.setUserPrincipal(principal);
                request.setAuthUser(principal.getName());
                return credential;
            }
            hashMap = this._ssoId2Principal;
            synchronized (hashMap) {
                this._ssoId2Principal.remove(ssoID);
                this._ssoPrincipal2Credential.remove(principal);
                this._ssoUsername2Id.remove(principal.getName());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSingleSignOn(HttpRequest request, HttpResponse response, Principal principal, Credential credential) {
        String ssoID = null;
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            while (this._ssoId2Principal.containsKey(ssoID = Long.toString(Math.abs(this._random.nextLong()), 30 + (int)(System.currentTimeMillis() % 7L)))) {
            }
            if (log.isDebugEnabled()) {
                log.debug("set ssoID=" + ssoID);
            }
            this._ssoId2Principal.put(ssoID, principal);
            this._ssoPrincipal2Credential.put(principal, credential);
            this._ssoUsername2Id.put(principal.getName(), ssoID);
        }
        Cookie cookie = new Cookie(SSO_COOKIE_NAME, ssoID);
        cookie.setPath("/");
        response.addSetCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSingleSignOn(String username) {
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            Object ssoID = this._ssoUsername2Id.remove(username);
            Object principal = this._ssoId2Principal.remove(ssoID);
            this._ssoPrincipal2Credential.remove(principal);
        }
    }
}

