/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seleniumhq.jetty7.continuation.Continuation;
import org.seleniumhq.jetty7.continuation.ContinuationListener;
import org.seleniumhq.jetty7.continuation.ContinuationSupport;
import org.seleniumhq.jetty7.http.gzip.GzipResponseWrapper;
import org.seleniumhq.jetty7.server.Request;
import org.seleniumhq.jetty7.server.handler.HandlerWrapper;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GzipHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(GzipHandler.class);
    protected Set<String> _mimeTypes;
    protected Set<String> _excluded;
    protected int _bufferSize = 8192;
    protected int _minGzipSize = 256;

    public Set<String> getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(Set<String> mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setMimeTypes(String mimeTypes) {
        if (mimeTypes != null) {
            this._mimeTypes = new HashSet<String>();
            StringTokenizer tok = new StringTokenizer(mimeTypes, ",", false);
            while (tok.hasMoreTokens()) {
                this._mimeTypes.add(tok.nextToken());
            }
        }
    }

    public Set<String> getExcluded() {
        return this._excluded;
    }

    public void setExcluded(Set<String> excluded) {
        this._excluded = excluded;
    }

    public void setExcluded(String excluded) {
        if (excluded != null) {
            this._excluded = new HashSet<String>();
            StringTokenizer tok = new StringTokenizer(excluded, ",", false);
            while (tok.hasMoreTokens()) {
                this._excluded.add(tok.nextToken());
            }
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    public void setMinGzipSize(int minGzipSize) {
        this._minGzipSize = minGzipSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handler == null || !this.isStarted()) return;
        String ae = request.getHeader("accept-encoding");
        if (ae != null && ae.indexOf("gzip") >= 0 && !response.containsHeader("Content-Encoding") && !"HEAD".equalsIgnoreCase(request.getMethod())) {
            String ua;
            if (this._excluded != null && this._excluded.contains(ua = request.getHeader("User-Agent"))) {
                this._handler.handle(target, baseRequest, request, response);
                return;
            }
            GzipResponseWrapper wrappedResponse = this.newGzipResponseWrapper(request, response);
            boolean exceptional = true;
            try {
                this._handler.handle(target, baseRequest, request, wrappedResponse);
                exceptional = false;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                Continuation continuation = ContinuationSupport.getContinuation(request);
                if (continuation.isSuspended() && continuation.isResponseWrapped()) {
                    continuation.addContinuationListener(new ContinuationListener(wrappedResponse){
                        final /* synthetic */ GzipResponseWrapper val$wrappedResponse;
                        {
                            this.val$wrappedResponse = gzipResponseWrapper;
                        }

                        public void onComplete(Continuation continuation) {
                            try {
                                this.val$wrappedResponse.finish();
                            }
                            catch (IOException e) {
                                LOG.warn(e);
                            }
                        }

                        public void onTimeout(Continuation continuation) {
                        }
                    });
                    throw throwable;
                } else if (exceptional && !response.isCommitted()) {
                    wrappedResponse.resetBuffer();
                    wrappedResponse.noGzip();
                    throw throwable;
                } else {
                    wrappedResponse.finish();
                }
                throw throwable;
            }
            Continuation continuation = ContinuationSupport.getContinuation(request);
            if (continuation.isSuspended() && continuation.isResponseWrapped()) {
                continuation.addContinuationListener(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            if (exceptional && !response.isCommitted()) {
                wrappedResponse.resetBuffer();
                wrappedResponse.noGzip();
                return;
            }
            wrappedResponse.finish();
            return;
        }
        this._handler.handle(target, baseRequest, request, response);
    }

    protected GzipResponseWrapper newGzipResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        return new GzipResponseWrapper(request, response){
            {
                super.setMimeTypes(GzipHandler.this._mimeTypes);
                super.setBufferSize(GzipHandler.this._bufferSize);
                super.setMinGzipSize(GzipHandler.this._minGzipSize);
            }

            protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
                return GzipHandler.this.newWriter(out, encoding);
            }
        };
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }
}

