/*
 * Decompiled with CFR 0.152.
 */
package fitbook.money;

public class Money {
    private long cents;

    public Money(long cents) {
        this.cents = cents;
    }

    public Money(double amount) {
        this.cents = (long)(amount * 100.0 + 0.5);
    }

    public Money() {
        this(0L);
    }

    public boolean greaterThan(Money money) {
        return this.cents > money.cents;
    }

    public boolean greaterThanEqual(Money money) {
        return this.cents >= money.cents;
    }

    public Money times(double rate) {
        return new Money((long)((double)this.cents * rate + 0.5));
    }

    public boolean equals(Object other) {
        return other instanceof Money && ((Money)other).cents == this.cents;
    }

    public int hashCode() {
        return (int)this.cents;
    }

    public String toString() {
        long positiveCents = Math.abs(this.cents);
        String centString = "" + positiveCents % 100L;
        if (centString.length() == 1) {
            centString = centString + "0";
        }
        String amountString = positiveCents / 100L + "." + centString;
        if (this.cents < 0L) {
            return "-" + amountString;
        }
        return "$" + amountString;
    }

    public static Money parse(String sInitial) {
        if (!sInitial.startsWith("$")) {
            throw new RuntimeException("Invalid Money");
        }
        String s = sInitial.substring(1);
        int dot = s.indexOf(".");
        if (dot < 0 || dot != s.length() - 3) {
            throw new RuntimeException("Invalid money");
        }
        double amount = Double.valueOf(s) * 100.0 + 0.5;
        return new Money((long)amount);
    }

    public boolean isZero() {
        return this.cents == 0L;
    }

    public Money plus(Money money) {
        return new Money(this.cents + money.cents);
    }

    public Money minus(Money money) {
        return new Money(this.cents - money.cents);
    }

    public Money negate() {
        return new Money(-this.cents);
    }
}

