/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch;

import fitlibrary.batch.resultsOut.ParallelFolderTestResultRepository;
import fitlibrary.batch.trinidad.TestResult;
import fitlibrary.batch.trinidad.TestResultRepository;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestParallelFolderTestResultRepository {
    final Mockery context = new JUnit4Mockery();
    final TestResultRepository testResults = (TestResultRepository)this.context.mock(TestResultRepository.class);
    final TestResult result1 = (TestResult)this.context.mock(TestResult.class);
    final TestResult result2 = (TestResult)this.context.mock(TestResult.class, "TestResult2");
    Executor executor = new ThreadPerTaskExecutor();
    final ParallelFolderTestResultRepository testResultRepository = new ParallelFolderTestResultRepository(this.testResults, this.executor);

    @Test
    public void noTestResults() throws InterruptedException {
        this.testResultRepository.closeAndWaitForCompletion();
    }

    @Test
    public void oneTestResult() throws IOException, InterruptedException {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResultRepository)this.one(TestParallelFolderTestResultRepository.this.testResults)).recordTestResult(TestParallelFolderTestResultRepository.this.result1);
            }
        });
        this.testResultRepository.recordTestResult(this.result1);
        this.testResultRepository.closeAndWaitForCompletion();
    }

    @Test
    public void twoTestResults() throws IOException, InterruptedException {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResultRepository)this.one(TestParallelFolderTestResultRepository.this.testResults)).recordTestResult(TestParallelFolderTestResultRepository.this.result1);
                ((TestResultRepository)this.one(TestParallelFolderTestResultRepository.this.testResults)).recordTestResult(TestParallelFolderTestResultRepository.this.result2);
            }
        });
        this.testResultRepository.recordTestResult(this.result1);
        this.testResultRepository.recordTestResult(this.result2);
        this.testResultRepository.closeAndWaitForCompletion();
    }

    static class ThreadPerTaskExecutor
    implements Executor {
        ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    }
}

