/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.definedAction.DefineActionsOnPageSlowly;
import fitlibrary.exception.FitLibraryExceptionInHtml;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.utility.FileIO;
import fitlibrary.utility.SimpleWikiTranslator;
import java.io.File;
import java.util.List;

public class DefineActionsOnPage
extends DefineActionsOnPageSlowly {
    private final String rootLocation;

    public DefineActionsOnPage(String topPageName, String rootLocation, RuntimeContextInternal runtime) {
        super(topPageName, runtime);
        this.rootLocation = rootLocation;
    }

    public DefineActionsOnPage(String topPageName, RuntimeContextInternal runtime) {
        this(topPageName, "FitNesseRoot", runtime);
    }

    @Override
    public void process() throws Exception {
        String errors = this.processPagesAsFiles(this.topPageName.substring(1));
        if (!"".equals(errors)) {
            throw new FitLibraryExceptionInHtml("<ul>" + errors + "</ul>");
        }
    }

    private String processPagesAsFiles(String pageName) throws Exception {
        String errors = "";
        String fullPageName = this.rootLocation + "/" + pageName.replaceAll("\\.", "/");
        File diry = new File(this.fitNesseDiry(), fullPageName);
        List<File> files = FileIO.filesWithSuffix(diry, "txt");
        for (File file : files) {
            String wiki = FileIO.read(file);
            String html = SimpleWikiTranslator.translate(wiki);
            try {
                if (!html.contains("<table")) continue;
                String fileName = file.getAbsolutePath().replaceAll("/", ".").replaceAll("\\\\", ".");
                Tables tables = TableFactory.tables(html);
                this.parseDefinitions(tables, this.determineClassName("", fileName), this.fileToPageName(file));
            }
            catch (Exception e) {
                errors = errors + "<li>" + e.getMessage() + "</li>\n";
            }
        }
        return errors;
    }

    private String fileToPageName(File file) {
        int diryIndex;
        String page = file.getAbsolutePath();
        int fitNesseRootIndex = page.indexOf("FitNesseRoot" + File.separator);
        if (fitNesseRootIndex >= 0) {
            page = page.substring(fitNesseRootIndex + "FitNesseRoot/".length());
        }
        if ((diryIndex = page.lastIndexOf(File.separator)) >= 0) {
            page = page.substring(0, diryIndex);
        }
        page = page.replaceAll("\\" + File.separator, ".");
        return page;
    }
}

