/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.domainAdapter;

import fitlibrary.annotation.ShowSelectedActions;
import fitlibrary.annotation.SimpleAction;
import fitlibrary.traverse.DomainAdapter;

@ShowSelectedActions
public class StringAdapter
implements DomainAdapter {
    private final String subject;

    public StringAdapter(String subject) {
        this.subject = subject;
    }

    public String[] split(String separator) {
        if (separator.isEmpty()) {
            return this.subject.split(" ");
        }
        if (separator.equals("\\n")) {
            return this.subject.split("\n");
        }
        return this.subject.split(separator);
    }

    public String toString() {
        return this.subject.toString();
    }

    @Override
    public Object getSystemUnderTest() {
        return this.subject;
    }

    @SimpleAction(wiki="|''<i>index of</i>''|text|", tooltip="What is the offset of the text in the string?")
    public int indexOf(String pattern) {
        return this.subject.indexOf(pattern);
    }

    @SimpleAction(wiki="|''<i>index of</i>''|text|''<i>from</i>''|start|", tooltip="What is the offset of the text in the string, starting at start?")
    public int indexOf(String pattern, int from) {
        return this.subject.indexOf(pattern, from);
    }

    @SimpleAction(wiki="|''<i>last index of</i>''|text|", tooltip="What is the last offset of the text in the string?")
    public int lastIndexOf(String pattern) {
        return this.subject.lastIndexOf(pattern);
    }

    @SimpleAction(wiki="|''<i>compare to</i>''|text|", tooltip="What is the result of comparing the text to the string?")
    public int compareTo(String pattern) {
        return this.subject.compareTo(pattern);
    }

    @SimpleAction(wiki="|''<i>is equals</i>''|text|", tooltip="Returns whether the text is the same as the string.")
    public boolean isEquals(String pattern) {
        return this.subject.equals(pattern);
    }

    @SimpleAction(wiki="|''<i>contains</i>''|text|", tooltip="Returns whether the string contains the text.")
    public boolean contains(String pattern) {
        return this.subject.contains(pattern);
    }

    @SimpleAction(wiki="|''<i>replace</i>''|pattern|replacement|", tooltip="Returns the result of replacing the pattern by the replacement in the string.")
    public String replace(String pattern, String replacement) {
        return this.subject.replace(pattern, replacement);
    }
}

