/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.dynamicVariable;

import fitlibrary.dynamicVariable.DynamicVariablesRecording;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class DynamicVariablesRecordingToFile
implements DynamicVariablesRecording {
    private String fileName;
    private Properties props = new Properties();

    public DynamicVariablesRecordingToFile(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void record(String key, String value) {
        this.props.setProperty(key, value);
    }

    @Override
    public void write() throws IOException {
        if (this.fileName.equals("pleaseThrowAnExceptionOnThisFile")) {
            throw new IOException("Some file exception");
        }
        Properties original = new Properties();
        this.collectOriginalProperties(original);
        for (Object key : this.props.keySet()) {
            original.setProperty(key.toString(), this.props.getProperty(key.toString()));
        }
        FileOutputStream fileWriter = new FileOutputStream(new File(this.fileName));
        original.store(fileWriter, "Recorded on " + new Date());
        fileWriter.close();
    }

    private void collectOriginalProperties(Properties original) {
        try {
            FileInputStream fileReader = new FileInputStream(new File(this.fileName));
            original.load(fileReader);
            fileReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isRecording() {
        return true;
    }
}

