/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.exception.method;

import fitlibrary.exception.FitLibraryExceptionInHtml;
import java.util.List;

public class MissingMethodException
extends FitLibraryExceptionInHtml {
    private static final long serialVersionUID = 1L;
    private List<String> signatures;
    private List<Class<?>> classes;

    public MissingMethodException(List<String> signatures, List<Class<?>> classes) {
        super("Missing method, possibly: " + MissingMethodException.htmlListOfSignatures(signatures) + "<hr/>In:" + MissingMethodException.htmlListOfClassNames(classes));
        this.signatures = signatures;
        this.classes = classes;
    }

    public List<String> getMethodSignature() {
        return this.signatures;
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }

    public String htmlListOfClassNames() {
        return MissingMethodException.htmlListOfClassNames(this.classes);
    }

    public static String htmlListOfClassNames(List<Class<?>> classes) {
        String result = "<ul>";
        for (Class<?> c : classes) {
            result = result + "<li>" + c.getCanonicalName() + "</li>";
        }
        return result + "</ul>";
    }

    public String htmlInnerListOfSignature() {
        String result = "";
        for (String s : this.signatures) {
            result = result + "<li>" + s + "</li>";
        }
        return result;
    }

    public static String htmlListOfSignatures(List<String> signatures) {
        String result = "<ul>";
        for (String s : signatures) {
            result = result + "<li>" + s + "</li>";
        }
        return result + "</ul>";
    }
}

