/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.flow.IScopeStack;
import fitlibrary.flow.IScopeState;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.RuntimeContextual;
import fitlibrary.traverse.workflow.FlowEvaluator;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.option.None;
import fitlibrary.utility.option.Option;
import fitlibrary.utility.option.Some;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class ScopeStack
implements IScopeStack {
    private static Logger logger = FitLibraryLogger.getLogger(ScopeStack.class);
    private final TypedObject flowEvaluator;
    protected final Stack<TypedObject> stack = new Stack();
    protected Option<TypedObject> suiteOption = None.none();
    protected List<TypedObject> selectObjects = new ArrayList<TypedObject>();
    protected List<TypedObject> globals = new ArrayList<TypedObject>();
    protected final TypedObject global;
    private Map<String, TypedObject> selectNames = new HashMap<String, TypedObject>();
    private boolean abandon = false;
    private boolean stopOnError = false;

    public ScopeStack(FlowEvaluator flowEvaluator, TypedObject global) {
        this.flowEvaluator = new GenericTypedObject(flowEvaluator);
        this.global = global;
        this.globals.add(global);
    }

    @Override
    public void clearAllButSuite() {
        this.stack.clear();
    }

    @Override
    public void push(TypedObject typedObject) {
        logger.trace((Object)("Pushed " + typedObject.getSubject()));
        if (typedObject.getSubject() instanceof SuiteEvaluator && this.suiteOption.isNone()) {
            this.suiteOption = new Some<TypedObject>(typedObject);
        } else if (this.stack.isEmpty() && this.selectObjects.isEmpty()) {
            this.selectObjects.add(typedObject);
        } else {
            this.stack.push(typedObject);
        }
    }

    @Override
    public List<TypedObject> poppedAtEndOfTable() {
        ArrayList<TypedObject> results = new ArrayList<TypedObject>();
        while (!this.stack.isEmpty()) {
            TypedObject top = this.stack.pop();
            results.add(top);
            logger.trace((Object)("Popped " + top.getSubject()));
        }
        return results;
    }

    @Override
    public List<TypedObject> poppedAtEndOfStorytest() {
        List<TypedObject> results = this.poppedAtEndOfTable();
        for (TypedObject typedObject : this.selectObjects) {
            results.add(typedObject);
        }
        this.selectObjects.clear();
        for (TypedObject to : results) {
            logger.trace((Object)("Popped " + to.getSubject()));
        }
        return results;
    }

    @Override
    public TypedObject pop() {
        return this.stack.pop();
    }

    @Override
    public List<TypedObject> objectsForLookup() {
        ArrayList<TypedObject> objects = new ArrayList<TypedObject>();
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            this.addObject((TypedObject)this.stack.elementAt(i), objects);
        }
        for (TypedObject typedObject : this.selectObjects) {
            this.addObject(typedObject, objects);
        }
        if (this.suiteOption.isSome()) {
            this.addObject(this.suiteOption.get(), objects);
        }
        for (TypedObject typedObject : this.globals) {
            this.addObject(typedObject, objects);
        }
        this.addObject(this.flowEvaluator, objects);
        return objects;
    }

    private void addObject(TypedObject typedObject, List<TypedObject> accumulatingObjects) {
        if (typedObject == null) {
            return;
        }
        if (typedObject.isNull()) {
            return;
        }
        if (accumulatingObjects.contains(typedObject)) {
            return;
        }
        accumulatingObjects.add(typedObject);
        if (typedObject.hasTypedSystemUnderTest()) {
            this.addObject(typedObject.getTypedSystemUnderTest(), accumulatingObjects);
        }
    }

    @Override
    public List<Class<?>> possibleClasses() {
        ArrayList results = new ArrayList();
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            this.addClass(((TypedObject)this.stack.elementAt(i)).getSubject(), results);
        }
        for (TypedObject t : this.selectObjects) {
            this.addClass(t.getSubject(), results);
        }
        if (this.suiteOption.isSome()) {
            this.addClass(this.suiteOption.get().getSubject(), results);
        }
        for (TypedObject t : this.globals) {
            if (t == this.global) continue;
            this.addClass(t.getSubject(), results);
        }
        return results;
    }

    private void addClass(Object subject, ArrayList<Class<?>> results) {
        if (subject == null) {
            return;
        }
        if (this.toBeVisible(subject) && !results.contains(subject.getClass())) {
            results.add(subject.getClass());
        }
        if (subject instanceof DomainAdapter) {
            this.addClass(((DomainAdapter)subject).getSystemUnderTest(), results);
        }
    }

    private boolean toBeVisible(Object subject) {
        Package aPackage = subject.getClass().getPackage();
        if (aPackage == null) {
            return true;
        }
        String packageName = aPackage.getName();
        if (!packageName.startsWith("fitlibrary")) {
            return true;
        }
        return packageName.startsWith("fitlibrary.specify") || packageName.startsWith("fitlibraryGeneric.specify");
    }

    @Override
    public void temporarilyAdd(Evaluator evaluator) {
        logger.trace((Object)("Pushed " + evaluator));
        this.stack.push(new GenericTypedObject(evaluator));
    }

    @Override
    public void removeTemporary(Evaluator evaluator) {
        logger.trace((Object)("Pop from scope stack: " + evaluator));
        TypedObject top = this.stack.pop();
        if (top.getSubject() != evaluator) {
            throw new RuntimeException("Whoops, temporary was not on the top of the stack!");
        }
    }

    @Override
    public IScopeState currentState() {
        final int size = this.stack.size();
        return new IScopeState(){

            @Override
            public List<TypedObject> restore() {
                ArrayList<TypedObject> results = new ArrayList<TypedObject>();
                while (ScopeStack.this.stack.size() > size) {
                    results.add(ScopeStack.this.stack.pop());
                }
                return results;
            }
        };
    }

    @Override
    public void addNamedObject(String name, TypedObject typedObject) {
        logger.trace((Object)("Pushed " + typedObject.getSubject()));
        this.selectObjects.add(typedObject);
        this.selectNames.put(name, typedObject);
    }

    @Override
    public void select(String name) {
        TypedObject typedObject = this.selectNames.get(name);
        if (typedObject == null) {
            throw new FitLibraryException("Unknown name");
        }
        logger.trace((Object)("Selected " + typedObject.getSubject()));
        this.selectObjects.remove(typedObject);
        this.selectObjects.add(0, typedObject);
    }

    @Override
    public void addGlobal(TypedObject typedObject) {
        this.globals.add(typedObject);
    }

    @Override
    public void setAbandon(boolean abandon) {
        this.abandon = abandon;
    }

    @Override
    public boolean isAbandon() {
        return this.abandon;
    }

    @Override
    public boolean isStopOnError() {
        return this.stopOnError;
    }

    @Override
    public void setStopOnError(boolean stop) {
        this.stopOnError = stop;
    }

    @Override
    public void switchRuntime(RuntimeContextInternal runtime) {
        this.setRuntimeContextOf(this.flowEvaluator.getSubject(), runtime);
        for (TypedObject aGlobal : this.globals) {
            this.setRuntimeContextOf(aGlobal.getSubject(), runtime);
        }
    }

    private void setRuntimeContextOf(Object object, RuntimeContextInternal runtime) {
        if (object instanceof RuntimeContextual) {
            ((RuntimeContextual)object).setRuntimeContext(runtime);
        }
        if (object instanceof DomainAdapter) {
            this.setRuntimeContextOf(((DomainAdapter)object).getSystemUnderTest(), runtime);
        }
    }
}

