/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.matcher;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.table.TableElement;
import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;

public abstract class TableElementBuilder<From extends TableElement, Builder extends TableElementBuilder, To extends TableElement> {
    protected final Class<From> type;
    protected List<Builder> elementBuilders = new ArrayList<Builder>();
    final List<To> listOfMockElements = new ArrayList<To>();
    protected String leader = "";
    protected String trailer = "";
    protected String tagLine = "";

    public TableElementBuilder(Class<From> type) {
        this.type = type;
    }

    public From mock(Mockery context) {
        return this.mock(context, "", 0);
    }

    public From mock(Mockery context, String name) {
        return this.mock(context, name, 0);
    }

    public From mock(Mockery context, String path, int index) {
        String localPath = this.localPath(path, index);
        final TableElement from = (TableElement)context.mock(this.type, localPath);
        int count = 0;
        for (TableElementBuilder builder : this.elementBuilders) {
            this.listOfMockElements.add(builder.mock(context, localPath, count++));
        }
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TableElement)this.allowing(from)).isEmpty();
                this.will(1.returnValue((Object)TableElementBuilder.this.listOfMockElements.isEmpty()));
                ((TableElement)this.allowing(from)).size();
                this.will(1.returnValue((Object)TableElementBuilder.this.listOfMockElements.size()));
                ((TableElement)this.allowing(from)).iterator();
                this.will(1.returnIterator(TableElementBuilder.this.listOfMockElements));
                ((TableElement)this.allowing(from)).getType();
                this.will(1.returnValue((Object)TableElementBuilder.this.type.getSimpleName()));
                ((TableElement)this.allowing(from)).getLeader();
                this.will(1.returnValue((Object)TableElementBuilder.this.leader));
                ((TableElement)this.allowing(from)).getTrailer();
                this.will(1.returnValue((Object)TableElementBuilder.this.trailer));
                ((TableElement)this.allowing(from)).getTagLine();
                this.will(1.returnValue((Object)TableElementBuilder.this.tagLine));
                for (int i = 0; i < TableElementBuilder.this.elementBuilders.size(); ++i) {
                    int ii = i;
                    ((TableElement)this.allowing(from)).at(i);
                    this.will(1.returnValue(TableElementBuilder.this.listOfMockElements.get(ii)));
                }
            }
        });
        if (this.listOfMockElements.isEmpty()) {
            context.checking((ExpectationBuilder)new Expectations(){
                {
                    ((TableElement)this.allowing(from)).last();
                    this.will(2.throwException((Throwable)new FitLibraryException("It's empty.")));
                }
            });
        } else {
            context.checking((ExpectationBuilder)new Expectations(){
                {
                    ((TableElement)this.allowing(from)).last();
                    this.will(3.returnValue(TableElementBuilder.this.listOfMockElements.get(TableElementBuilder.this.elementBuilders.size() - 1)));
                }
            });
        }
        return (From)from;
    }

    protected String localPath(String path, int index) {
        if (path.isEmpty()) {
            return this.type.getSimpleName() + "[" + index + "]";
        }
        return path + "." + this.type.getSimpleName() + "[" + index + "]";
    }

    protected List<Builder> withCopyExtendedWith(Builder ... els) {
        ArrayList<Builder> copy = new ArrayList<Builder>(this.elementBuilders);
        for (Builder builder : els) {
            copy.add(builder);
        }
        return copy;
    }

    protected void with(TableElementBuilder<From, Builder, To> copy, Builder ... els) {
        ArrayList<Builder> newElementBuilders = new ArrayList<Builder>(this.elementBuilders);
        for (Builder builder : els) {
            newElementBuilders.add(builder);
        }
        copy.leader = this.leader;
        copy.trailer = this.trailer;
        copy.tagLine = this.tagLine;
        copy.elementBuilders = newElementBuilders;
    }

    public void withLeader(TableElementBuilder<From, Builder, To> copy, String allowedLeader) {
        copy.leader = allowedLeader;
        copy.trailer = this.trailer;
        copy.tagLine = this.tagLine;
        copy.elementBuilders = this.elementBuilders;
    }

    public void withTrailer(TableElementBuilder<From, Builder, To> copy, String allowedTrailer) {
        copy.leader = this.leader;
        copy.trailer = allowedTrailer;
        copy.tagLine = this.tagLine;
        copy.elementBuilders = this.elementBuilders;
    }

    public void withTagLine(TableElementBuilder<From, Builder, To> copy, String allowedTagLine) {
        copy.leader = this.leader;
        copy.trailer = this.trailer;
        copy.tagLine = allowedTagLine;
        copy.elementBuilders = this.elementBuilders;
    }
}

