/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.self;

import fitlibrary.log.FitLibraryLogger;
import fitlibrary.parser.DelegateParser;
import fitlibrary.typed.Typed;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.log4j.Logger;

public class SelfParser
extends DelegateParser
implements Cloneable {
    static Logger logger = FitLibraryLogger.getLogger(SelfParser.class);
    private Method parseMethod;

    public static SelfParser findSelfParser(Class<?> type) {
        Method parseMethod = SelfParser.findParseMethod(type);
        if (parseMethod == null) {
            return null;
        }
        return new SelfParser(parseMethod);
    }

    public SelfParser(Method parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Override
    public Object parse(String s, Typed typed) throws Exception {
        logger.trace((Object)("Parsing with " + this.parseMethod.getName() + "() of " + this.parseMethod.getDeclaringClass().getName()));
        return this.parseMethod.invoke(null, s);
    }

    public static Method findParseMethod(Class<?> type) {
        try {
            Method method = type.getMethod("parse", String.class);
            int modifiers = method.getModifiers();
            Class<?> returnType = method.getReturnType();
            if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && returnType != Void.class && !returnType.isPrimitive()) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }
}

