/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fitlibrary.exception.FitLibraryException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CopyFilesFromJar {
    public static void copyCssAndImageFilesFromJar(File theInDiry) throws IOException, SecurityException {
        File cssDiry;
        File filesDiry = new File(theInDiry, "files");
        if (!filesDiry.exists()) {
            filesDiry.mkdir();
        }
        if (!(cssDiry = new File(filesDiry, "css")).exists()) {
            cssDiry.mkdir();
        }
        CopyFilesFromJar.createFileIfNeeded(new File(cssDiry, "fitnesse.css"), "css/fitnesse_base.css");
        File imagesDiry = new File(filesDiry, "images");
        if (!imagesDiry.exists()) {
            imagesDiry.mkdir();
        }
        CopyFilesFromJar.createFileIfNeeded(new File(imagesDiry, "collapsableClosed.gif"), "images/collapsableClosed.gif");
        CopyFilesFromJar.createFileIfNeeded(new File(imagesDiry, "collapsableOpen.gif"), "images/collapsableOpen.gif");
    }

    private static void createFileIfNeeded(File target, String resource) throws FileNotFoundException, IOException {
        int ch;
        if (target.exists()) {
            return;
        }
        String fullResource = "Resources/FitNesseRoot/files/" + resource;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream reader = classLoader.getResourceAsStream(fullResource);
        if (reader == null) {
            throw new FitLibraryException("Unable to access resource from jar: " + fullResource);
        }
        BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(target));
        while ((ch = reader.read()) >= 0) {
            writer.write(ch);
        }
        reader.close();
        writer.close();
    }
}

