/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.special;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.special.DoActionInContext;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.utility.Pair;
import fitlibraryGeneric.typed.GenericTypedObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestDoActionInContext {
    final Mockery context = new Mockery();
    final ICalledMethodTarget target = (ICalledMethodTarget)this.context.mock(ICalledMethodTarget.class, "inner");
    final RuntimeContextInternal runtime = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);
    final TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    final Parser parser1 = (Parser)this.context.mock(Parser.class, "parser1");
    final Parser parser2 = (Parser)this.context.mock(Parser.class, "parser2");
    final VariableResolver resolver = (VariableResolver)this.context.mock(VariableResolver.class);

    @Before
    public void allowingExpectations() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(TestDoActionInContext.this.runtime)).getTestResults();
                this.will(1.returnValue((Object)TestDoActionInContext.this.testResults));
            }
        });
    }

    @Test(expected=RuntimeException.class)
    public void runWithNoArgsCausesException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ICalledMethodTarget)this.oneOf(TestDoActionInContext.this.target)).getParameterParsers();
                this.will(2.returnValue((Object)new Parser[0]));
                ((ICalledMethodTarget)this.oneOf(TestDoActionInContext.this.target)).invoke(new Object[0]);
                this.will(2.throwException((Throwable)new RuntimeException("failed")));
            }
        });
        Row row = TableFactory.row();
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 1, false, this.runtime);
        doActionInContext.run();
    }

    @Test
    public void runWithNoArgsReturnsString() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ICalledMethodTarget)this.oneOf(TestDoActionInContext.this.target)).getParameterParsers();
                this.will(3.returnValue((Object)new Parser[0]));
                ((ICalledMethodTarget)this.oneOf(TestDoActionInContext.this.target)).invoke(new Object[0]);
                this.will(3.returnValue((Object)"result"));
            }
        });
        Row row = TableFactory.row("m");
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 1, false, this.runtime);
        MatcherAssert.assertThat((Object)doActionInContext.run(), (Matcher)CoreMatchers.is((Object)"result"));
    }

    @Test
    public void runWith1ArgReturnsString() throws Exception {
        final Row row = TableFactory.row("m", "22");
        final Parser[] parserArray = new Parser[]{this.parser1};
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ICalledMethodTarget)this.oneOf(TestDoActionInContext.this.target)).getParameterParsers();
                this.will(4.returnValue((Object)parserArray));
                ((Parser)this.oneOf(TestDoActionInContext.this.parser1)).parseTyped((Cell)row.at(1), TestDoActionInContext.this.testResults);
                this.will(4.returnValue((Object)new GenericTypedObject("22")));
                ((ICalledMethodTarget)this.oneOf(TestDoActionInContext.this.target)).invoke(new Object[]{"22"});
                this.will(4.returnValue((Object)"result2"));
            }
        });
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 2, false, this.runtime);
        MatcherAssert.assertThat((Object)doActionInContext.run(), (Matcher)CoreMatchers.is((Object)"result2"));
    }

    @Test
    public void runWith2ArgsReturnsInt() throws Exception {
        final Row row = TableFactory.row("m", "22", "n", "44");
        final Parser[] parserArray = new Parser[]{this.parser1, this.parser2};
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ICalledMethodTarget)this.oneOf(TestDoActionInContext.this.target)).getParameterParsers();
                this.will(5.returnValue((Object)parserArray));
                ((Parser)this.oneOf(TestDoActionInContext.this.parser1)).parseTyped((Cell)row.at(1), TestDoActionInContext.this.testResults);
                this.will(5.returnValue((Object)new GenericTypedObject("22")));
                ((Parser)this.oneOf(TestDoActionInContext.this.parser2)).parseTyped((Cell)row.at(3), TestDoActionInContext.this.testResults);
                this.will(5.returnValue((Object)new GenericTypedObject("44")));
                ((ICalledMethodTarget)this.oneOf(TestDoActionInContext.this.target)).invoke(new Object[]{"22", "44"});
                this.will(5.returnValue((Object)"result2"));
            }
        });
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 2, false, this.runtime);
        MatcherAssert.assertThat((Object)doActionInContext.run(), (Matcher)CoreMatchers.is((Object)"result2"));
    }

    @Test
    public void CanAccessRuntime() throws Exception {
        Row row = TableFactory.row("any");
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 2, false, this.runtime);
        MatcherAssert.assertThat((Object)doActionInContext.getRuntime(), (Matcher)CoreMatchers.is((Object)this.runtime));
    }

    @Test
    public void CanAccessSpecialCellsToPass() throws Exception {
        Row row = TableFactory.row("m", "22", "n", "44");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestDoActionInContext.this.testResults)).pass();
            }
        });
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 2, false, this.runtime);
        doActionInContext.cellAt(0).pass();
        MatcherAssert.assertThat((Object)((Cell)row.at(2)).didPass(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void CanAccessSpecialCellsToFail() throws Exception {
        Row row = TableFactory.row("m", "22", "n", "44");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(TestDoActionInContext.this.runtime)).getResolver();
                this.will(7.returnValue((Object)TestDoActionInContext.this.resolver));
                ((VariableResolver)this.oneOf(TestDoActionInContext.this.resolver)).resolve("44");
                this.will(TestDoActionInContext.this.resolveTo("44"));
                ((TestResults)this.oneOf(TestDoActionInContext.this.testResults)).fail();
            }
        });
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 2, false, this.runtime);
        doActionInContext.cellAt(1).fail("error");
        MatcherAssert.assertThat((Object)((Cell)row.at(3)).didFail(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void CanAccessSpecialCellsToError() throws Exception {
        Row row = TableFactory.row("m", "22", "n", "44");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestDoActionInContext.this.testResults)).exception();
            }
        });
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 2, false, this.runtime);
        doActionInContext.cellAt(1).error(new RuntimeException());
        MatcherAssert.assertThat((Object)((Cell)row.at(3)).hadError(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=FitLibraryException.class)
    public void CannotAccessSpecialCellsOutside() throws Exception {
        Row row = TableFactory.row("m", "22", "n", "44");
        DoActionInContext doActionInContext = new DoActionInContext(this.target, row, 0, 2, false, this.runtime);
        doActionInContext.cellAt(2).fail("error");
    }

    protected Action resolveTo(String string) {
        return Expectations.returnValue(new Pair<String, Tables>(string, TableFactory.tables()));
    }
}

