/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.specify.parser;

import fitlibrary.traverse.FitLibrarySelector;
import fitlibrary.traverse.Traverse;
import java.beans.PropertyEditorSupport;

public class UsePropertyEditor {
    public MyPoint aPoint(MyPoint point) {
        return point;
    }

    public Traverse aPointAsDomainObject(MyPoint point) {
        return FitLibrarySelector.selectDomainCheck(point);
    }

    public static class MyPointEditor
    extends PropertyEditorSupport {
        @Override
        public void setAsText(String s) throws IllegalArgumentException {
            if (!s.startsWith("(") || !s.endsWith(")")) {
                throw new RuntimeException("Badly formatted point");
            }
            int comma = s.indexOf(",");
            if (comma < 0) {
                throw new RuntimeException("Badly formatted point");
            }
            int x = Integer.parseInt(s.substring(1, comma));
            int y = Integer.parseInt(s.substring(comma + 1, s.length() - 1));
            this.setValue(new MyPoint(x, y));
        }

        @Override
        public String getAsText() {
            MyPoint value = (MyPoint)this.getValue();
            return "[" + value.getX() + "," + value.getY() + "]";
        }
    }

    public static class MyPoint {
        private int x;
        private int y;

        public MyPoint(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MyPoint)) {
                return false;
            }
            MyPoint other = (MyPoint)object;
            return this.x == other.x && this.y == other.y;
        }

        public int hashCode() {
            return this.x + this.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }
}

