/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.table.Table;
import fitlibrary.table.TableConversion;
import fitlibrary.table.TableElementOnList;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;

public class TablesOnList
extends TableElementOnList<Tables, Table>
implements Tables {
    public TablesOnList() {
        super("");
    }

    public TablesOnList(Table theTable) {
        this();
        ((TableElementOnList)this).add(theTable);
    }

    public TablesOnList(Tables tables) {
        this();
        this.addTables(tables);
    }

    public TablesOnList(String tag) {
        super(tag);
    }

    @Override
    public Tables deepCopy() {
        Tables copy = TableFactory.tables();
        for (Table table : this) {
            copy.add(table.deepCopy());
        }
        copy.setLeader(this.getLeader());
        copy.setTrailer(this.getTrailer());
        copy.setTagLine(this.getTagLine());
        return copy;
    }

    public Tables followingTables() {
        return this.fromAt(1);
    }

    @Override
    public void addTables(Tables tables) {
        for (Table table : tables) {
            ((TableElementOnList)this).add(table);
        }
    }

    @Override
    protected Tables newObject() {
        return new TablesOnList();
    }

    @Override
    public String report() {
        StringBuilder builder = new StringBuilder();
        this.toHtml(builder);
        return builder.toString();
    }

    @Override
    public void print(String heading) {
        System.out.println("---------Tables for " + heading + ":----------");
        System.out.println(this.toString());
        System.out.println("-------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parse asParse() {
        TableFactory.useOnLists(false);
        try {
            Parse parse = TableConversion.convert(this).parse();
            return parse;
        }
        finally {
            TableFactory.pop();
        }
    }

    @Override
    public Tables fromAt(int i) {
        return (Tables)this.fromTo(i, this.size());
    }

    public Tables getActualEmbeddedTables() {
        return this;
    }
}

