/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.table.TablesOnList;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestTablesOnList {
    Mockery context = new Mockery();
    TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    final Table table1 = (Table)TableBuilderForTests.table().mock(this.context, "", 0);
    final Table table2 = (Table)TableBuilderForTests.table().mock(this.context, "", 1);
    final Tables tables12 = TestTablesOnList.tables(this.table1, this.table2);

    @Before
    public void useListsFactory() {
        TableFactory.useOnLists(true);
    }

    @After
    public void stopUsingListsFactory() {
        TableFactory.pop();
    }

    @Test
    public void emptyTables() {
        MatcherAssert.assertThat((Object)TableFactory.tables().toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void iteratorIsEmptyWhenNoElements() {
        MatcherAssert.assertThat((Object)TableFactory.tables().iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void iteratorHasOneWhenOneElement() {
        Iterator iterator = TestTablesOnList.tables(this.table1).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.is((Object)this.table1));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void iteratorHasTwoWhenTwoElements() {
        Iterator iterator = this.tables12.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.is((Object)this.table1));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.is((Object)this.table2));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void iterableAfterFirstIsEmptyWhenNoElements() {
        Iterator iterator = TestTablesOnList.tables(new Table[0]).iterableFrom(1).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void iterableAfterFirstIsEmptyWhenOneElement() {
        Iterator iterator = TestTablesOnList.tables(this.table1).iterableFrom(1).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void iterableAfterFirstHasOneWhenTwoElements() {
        Iterator iterator = this.tables12.iterableFrom(1).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.is((Object)this.table2));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isEmpty() {
        MatcherAssert.assertThat((Object)TestTablesOnList.tables(new Table[0]).size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)TestTablesOnList.tables(new Table[0]).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void followingTables() {
        Tables tables = (Tables)this.tables12.fromAt(1);
        MatcherAssert.assertThat((Object)tables.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(tables.at(0), (Matcher)CoreMatchers.is((Object)this.table2));
    }

    @Test
    public void error() {
        final FitLibraryException fitLibraryException = new FitLibraryException("aa");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(TestTablesOnList.this.table1)).error(TestTablesOnList.this.testResults, (Throwable)fitLibraryException);
            }
        });
        this.tables12.error(this.testResults, fitLibraryException);
    }

    @Test
    public void addToTag() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(TestTablesOnList.this.table1)).addToTag("extra");
            }
        });
        this.tables12.addToTag("extra");
    }

    @Test
    public void deepCopy() {
        final Table table = (Table)TableBuilderForTests.table().mock(this.context, "", 55);
        final Table table2 = (Table)TableBuilderForTests.table().mock(this.context, "", 66);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(TestTablesOnList.this.table1)).deepCopy();
                this.will(3.returnValue((Object)table));
                ((Table)this.oneOf(TestTablesOnList.this.table2)).deepCopy();
                this.will(3.returnValue((Object)table2));
            }
        });
        this.tables12.setLeader("LL");
        this.tables12.setTrailer("TT");
        Tables tables = (Tables)this.tables12.deepCopy();
        MatcherAssert.assertThat((Object)tables.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(tables.at(0), (Matcher)CoreMatchers.is((Object)table));
        MatcherAssert.assertThat(tables.at(1), (Matcher)CoreMatchers.is((Object)table2));
        MatcherAssert.assertThat((Object)tables.getLeader(), (Matcher)CoreMatchers.is((Object)"LL"));
        MatcherAssert.assertThat((Object)tables.getTrailer(), (Matcher)CoreMatchers.is((Object)"TT"));
    }

    @Test
    public void toHtmlWithElements() {
        final StringBuilder stringBuilder = new StringBuilder();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(TestTablesOnList.this.table1)).toHtml(stringBuilder);
                ((Table)this.oneOf(TestTablesOnList.this.table2)).toHtml(stringBuilder);
            }
        });
        this.tables12.setLeader("LL");
        this.tables12.setTrailer("TT");
        this.tables12.toHtml(stringBuilder);
        MatcherAssert.assertThat((Object)stringBuilder.toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void addTables() {
        this.tables12.addTables(TestTablesOnList.tables(this.table2, this.table2));
        MatcherAssert.assertThat((Object)this.tables12.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(this.tables12.at(2), (Matcher)CoreMatchers.is((Object)this.table2));
        MatcherAssert.assertThat(this.tables12.at(3), (Matcher)CoreMatchers.is((Object)this.table2));
    }

    protected static Tables tables(Table ... tableArray) {
        TablesOnList tablesOnList = new TablesOnList();
        for (Table table : tableArray) {
            tablesOnList.add(table);
        }
        return tablesOnList;
    }
}

