/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.tableOnParse;

import fit.Parse;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.tableOnParse.TableElementOnParse;
import fitlibrary.tableOnParse.TableOnParse;
import fitlibrary.utility.ParseUtility;

public class TablesOnParse
extends TableElementOnParse<Table>
implements Tables {
    public TablesOnParse(Parse parse) {
        super(parse);
    }

    public TablesOnParse() {
        super(null);
    }

    public TablesOnParse(Table theTable) {
        this(theTable.parse());
    }

    public TablesOnParse(Tables tables) {
        this(ParseUtility.copyParse(tables.parse()));
    }

    @Override
    public Table at(int i) {
        return new TableOnParse(this.parse.at(i));
    }

    @Override
    public TablesOnParse add(Table table) {
        if (this.parse == null) {
            this.parse = table.parse();
        } else {
            this.parse.last().more = table.parse();
        }
        return this;
    }

    @Override
    public int size() {
        if (this.parse == null) {
            return 0;
        }
        return this.parse.size();
    }

    @Override
    public Tables deepCopy() {
        Tables copy = TableFactory.tables();
        for (Table table : this) {
            copy.add(table.deepCopy());
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TablesOnParse)) {
            return false;
        }
        TablesOnParse other = (TablesOnParse)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.at(i).equals(other.at(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Tables fromAt(int i) {
        return TableFactory.tables(this.at(i));
    }

    public Tables getActualEmbeddedTables() {
        return this.fromAt(0);
    }

    @Override
    public Tables fromTo(int from, int upto) {
        Tables result = TableFactory.tables();
        for (int i = from; i < upto; ++i) {
            result.add(this.at(i).deepCopy());
        }
        return result;
    }

    public Tables followingTables() {
        return new TablesOnParse(this.parse.more);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void error(TestResults testResults, Throwable e) {
        this.at(0).error(testResults, e);
    }

    @Override
    public String getType() {
        return "Tables";
    }

    @Override
    public String report() {
        return ParseUtility.toString(this.parse());
    }

    @Override
    public void addTables(Tables tables) {
        for (Table table : tables) {
            this.add(table);
        }
    }

    @Override
    public void print(String heading) {
        ParseUtility.printParse(this.parse(), "actual");
    }
}

