/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.tableOnParse;

import fitlibrary.runtime.RuntimeContextContainer;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestRowOnParse {
    RuntimeContextInternal runtime = new RuntimeContextContainer();
    Row row = TableFactory.row();

    @Test
    public void sizeOfEmptyRow() {
        MatcherAssert.assertThat((Object)this.row.size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.row.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void columnSpanWithNoCellsIsZero() throws Exception {
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void columnSpanWithOneCellWithNoColumnSpanSetIsOne() throws Exception {
        this.row.addCell("1");
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void columnSpanWithOneCellWithColumnSpanSet() throws Exception {
        this.row.addCell("1", 4);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void columnSpanWithMultipleCellsWithAndWithoutColumnSpanSet() throws Exception {
        this.row.addCell("1", 4);
        this.row.addCell("2");
        this.row.addCell("3", 2);
        this.row.addCell("4");
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void setColumnSpanWithNoCellsHadsOneCell() {
        this.row.setColumnSpan(4);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(0)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void setColumnSpanWithOneCellWithNoColumnSpanSet() {
        this.row.addCell("1");
        this.row.setColumnSpan(4);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(0)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void setColumnSpanWithOneCellWithColumnSpanSet() {
        this.row.addCell("1", 3);
        this.row.setColumnSpan(4);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(0)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void setColumnSpanWithMultipleCellsWithAndWithoutColumnSpanSetAddToTheColumnSpanOfLastCell() throws Exception {
        this.row.addCell("1", 4);
        this.row.addCell("2");
        this.row.addCell("3", 2);
        this.row.addCell("4", 4);
        this.row.setColumnSpan(15);
        MatcherAssert.assertThat((Object)this.row.getColumnSpan(), (Matcher)CoreMatchers.is((Object)15));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(0)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(1)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(2)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Cell)this.row.at(3)).getColumnSpan(), (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void plainMethodNameNoArg() {
        Row row = TableFactory.row("aa");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa"));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aa"));
    }

    @Test
    public void plainMethodNameOneArg() {
        Row row = TableFactory.row("aa", "1");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa|"));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aa"));
    }

    @Test
    public void plainMethodNameOneArgTwoKeywords() {
        Row row = TableFactory.row("aa", "1", "bb");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa|bb"));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aaBb"));
    }

    @Test
    public void plainMethodNameTwoArgs() {
        Row row = TableFactory.row("aa", "1", "bb", "2");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa|bb|"));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aaBb"));
    }

    @Test
    public void plainMethodNameTwoArgsThreeKeywords() {
        Row row = TableFactory.row("aa", "1", "bb", "2", ".");
        MatcherAssert.assertThat((Object)row.methodNameForPlain(this.runtime), (Matcher)CoreMatchers.is((Object)"aa|bb|."));
        MatcherAssert.assertThat((Object)row.methodNameForCamel(this.runtime), (Matcher)CoreMatchers.is((Object)"aaBbDot"));
    }

    @Test
    public void canReplaceRowAtStart() {
        Row row = TableFactory.row("a", "b");
        Row row2 = TableFactory.row("x", "y");
        Row row3 = TableFactory.row("m", "n");
        Table table = TableFactory.table();
        table.add(row);
        table.add(row2);
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)row));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)row2));
        table.replaceAt(0, row3);
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)row3));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)row2));
    }

    @Test
    public void canReplaceRowAtEnd() {
        Row row = TableFactory.row("a", "b");
        Row row2 = TableFactory.row("x", "y");
        Row row3 = TableFactory.row("m", "n");
        Table table = TableFactory.table();
        table.add(row);
        table.add(row2);
        table.replaceAt(1, row3);
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)row));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)row3));
    }
}

