/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fit.Fixture;
import fitlibrary.exception.classes.ConstructorNotVisible;
import fitlibrary.exception.classes.NoNullaryConstructor;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.AbstractDoCaller;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreateFromClassNameCaller
extends AbstractDoCaller {
    private static Logger logger = FitLibraryLogger.getLogger(CreateFromClassNameCaller.class);
    private static final ThreadLocal<Set<String>> packages = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("fit.");
            return hashSet;
        }
    };
    private String className;
    private Object object = null;
    private Exception exceptionToThrow = null;

    public CreateFromClassNameCaller(Row row, Evaluator evaluator) {
        this.className = this.substituteName(row.text(0, evaluator).trim());
        if (this.validClassName()) {
            try {
                Class<?> determineFullClass = this.determineFullClass();
                this.object = ClassUtility.newInstance(determineFullClass);
                logger.trace((Object)("Created " + this.object));
                if (row.size() > 1 && this.object instanceof Fixture) {
                    this.handleArgs((Fixture)this.object, row);
                }
            }
            catch (NoSuchMethodException ex) {
                this.exceptionToThrow = new NoNullaryConstructor(this.className, evaluator.getRuntimeContext());
            }
            catch (NoClassDefFoundError ex) {
                this.exceptionToThrow = new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                this.exceptionToThrow = new NoNullaryConstructor(this.className, evaluator.getRuntimeContext());
            }
            catch (IllegalAccessException ex) {
                this.exceptionToThrow = new ConstructorNotVisible(this.className, evaluator.getRuntimeContext());
            }
            catch (InvocationTargetException ex) {
                this.exceptionToThrow = ex;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean validClassName() {
        return !this.className.isEmpty() && !this.className.contains(" ") && (this.className.contains(".") || Character.isUpperCase(this.className.charAt(0)));
    }

    private String substituteName(String name) {
        if ("Import".equals(name) || "fit.Import".equals(name) || "ImportFixture".equals(name) || "fit.ImportFixture".equals(name)) {
            return "fitlibrary.DefaultPackages";
        }
        return name;
    }

    private Class<?> determineFullClass() throws ClassNotFoundException {
        try {
            return Class.forName(this.className);
        }
        catch (Throwable e) {
            try {
                return Class.forName(this.className + "Fixture");
            }
            catch (Throwable e1) {
                for (String s : packages.get()) {
                    try {
                        return Class.forName(s + this.className);
                    }
                    catch (Exception e2) {
                        try {
                            return Class.forName(s + this.className + "Fixture");
                        }
                        catch (ClassNotFoundException e3) {
                        }
                        catch (NoClassDefFoundError e4) {
                        }
                    }
                }
                throw new ClassNotFoundException(this.className);
            }
        }
    }

    private void handleArgs(Fixture fixture, Row row) {
        fixture.getArgsForTable(TableFactory.table(row).asParse());
    }

    @Override
    public boolean isValid() {
        return this.object != null || this.exceptionToThrow != null;
    }

    @Override
    public String ambiguityErrorMessage() {
        return "class " + this.className;
    }

    @Override
    public TypedObject run(Row row, TestResults testResults) throws Exception {
        if (this.exceptionToThrow != null) {
            throw this.exceptionToThrow;
        }
        return new GenericTypedObject(this.object);
    }

    public static void addDefaultPackage(String name) {
        packages.get().add(name + ".");
    }
}

