/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fit.Fixture;
import fitlibrary.definedAction.DefinedActionsRepository;
import fitlibrary.definedAction.ParameterBinder;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.traverse.TableEvaluator;
import fitlibrary.traverse.workflow.AbstractDoCaller;
import fitlibrary.traverse.workflow.caller.DefinedActionCallManager;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DefinedActionCaller
extends AbstractDoCaller {
    private static Logger logger = FitLibraryLogger.getLogger(DefinedActionCaller.class);
    private ParameterBinder binder;
    private String methodName;
    private RuntimeContextInternal runtime;
    private List<Object> actualArgs = new ArrayList<Object>();

    public DefinedActionCaller(Row row, RuntimeContextInternal runtime) {
        this.runtime = runtime;
        this.methodName = row.methodNameForCamel(runtime);
        this.actualArgs = this.actualArgs(row);
        this.binder = this.repository().lookupByCamel(this.methodName, this.actualArgs.size());
        if (this.binder == null) {
            this.lookupByClass();
        }
    }

    public DefinedActionCaller(String object, String className, Row row, RuntimeContextInternal runtime) {
        this.runtime = runtime;
        this.methodName = row.methodNameForCamel(runtime);
        this.actualArgs.add(object);
        this.actualArgs(row, this.actualArgs);
        this.binder = this.repository().lookupByClassByCamel(className, this.methodName, this.actualArgs.size() - 1, runtime);
        if (this.binder == null) {
            throw new FitLibraryException("Unknown defined action for object of class " + className);
        }
    }

    private DefinedActionsRepository repository() {
        return TemporaryPlugBoardForRuntime.definedActionsRepository();
    }

    private void lookupByClass() {
        Object objectName = this.runtime.getDynamicVariable("this");
        if (objectName != null) {
            Object className = this.runtime.getDynamicVariable(objectName + ".class");
            this.actualArgs.add(0, objectName.toString());
            if (className != null && !"".equals(className)) {
                this.binder = this.repository().lookupByClassByCamel(className.toString(), this.methodName, this.actualArgs.size() - 1, this.runtime);
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.binder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedObject run(Row row, TestResults testResults) {
        logger.trace((Object)("Calling " + this.methodName + this.binder.getParameterList() + " from " + this.binder.getPageName()));
        DefinedActionCallManager definedActionCallManager = this.runtime.getDefinedActionCallManager();
        definedActionCallManager.startCall(this.binder);
        this.runtime.pushLocalDynamicVariables();
        try {
            Object oldThisValue = this.runtime.getDynamicVariable("this");
            if (!this.actualArgs.isEmpty()) {
                this.runtime.setDynamicVariable("this", this.actualArgs.get(0));
            }
            this.binder.bindUni(this.actualArgs, this.runtime.getDynamicVariables());
            this.processDefinedAction(this.binder.getCopyOfBody(), row, testResults);
            this.runtime.setDynamicVariable("this", oldThisValue);
        }
        finally {
            definedActionCallManager.endCall(this.binder);
            this.runtime.popLocalDynamicVariables();
        }
        if (!this.runtime.toExpandDefinedActions() && definedActionCallManager.readyToShow() && !this.runtime.isAbandoned(testResults)) {
            row.add(TableFactory.cell(TableFactory.tables(definedActionCallManager.getShowsTable())));
        }
        return GenericTypedObject.NULL;
    }

    @Override
    public String ambiguityErrorMessage() {
        return "defined action " + this.methodName;
    }

    private List<Object> actualArgs(Row row) {
        return this.actualArgs(row, new ArrayList<Object>());
    }

    private List<Object> actualArgs(Row row, List<Object> result) {
        for (int i = 1; i < row.size(); i += 2) {
            Cell cell = (Cell)row.at(i);
            if (cell.hasEmbeddedTables(this.runtime.getResolver())) {
                result.add(cell.getEmbeddedTables());
                continue;
            }
            result.add(cell.text(this.runtime.getResolver()));
        }
        return result;
    }

    private void processDefinedAction(Tables definedActionBody, Row row, TestResults testResults) {
        TestResults subTestResults = TestResultsFactory.testResults();
        TableEvaluator tableEvaluator = this.runtime.getTableEvaluator();
        tableEvaluator.runInnerTables(definedActionBody, subTestResults);
        this.colourRowInReport(row, testResults, subTestResults);
        if (this.runtime.toExpandDefinedActions() || subTestResults.problems() || this.runtime.isAbandoned(testResults)) {
            Cell cell = TableFactory.cell(definedActionBody);
            ((Table)cell.at(0)).setLeader(Fixture.label(DefinedActionCaller.link(this.binder.getPageName())) + ((Table)cell.at(0)).getLeader());
            cell.calls();
            row.add(cell);
        }
    }

    private void colourRowInReport(Row row, TestResults testResults, TestResults subTestResults) {
        if (this.runtime.toExpandDefinedActions() || subTestResults.problems()) {
            if (!this.runtime.isAbandoned(testResults)) {
                if (subTestResults.passed()) {
                    row.passKeywords(testResults);
                } else if (subTestResults.errors()) {
                    for (int i = 0; i < row.size(); i += 2) {
                        ((Cell)row.at(i)).error(testResults, new FitLibraryException(""));
                    }
                } else if (subTestResults.failed()) {
                    for (int i = 0; i < row.size(); i += 2) {
                        ((Cell)row.at(i)).fail(testResults);
                    }
                } else {
                    for (int i = 0; i < row.size(); i += 2) {
                        ((Cell)row.at(i)).ignore(testResults);
                    }
                }
            }
        } else if (!this.runtime.isAbandoned(testResults)) {
            row.passKeywords(testResults);
        }
    }

    public static String link(String pageName) {
        if (pageName.equals("storytest table")) {
            return "Defined action call:";
        }
        return "Defined action call <a href='" + pageName + "'>." + pageName + "</a>:";
    }

    public static String link2(String pageName) {
        if (pageName.equals("storytest table")) {
            return "storytest";
        }
        return "<a href='" + pageName + "'>." + pageName + "</a>:";
    }
}

