/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.typed;

import fitlibrary.closure.Closure;
import fitlibrary.closure.LookupClosure;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.RuntimeContextual;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.awt.Point;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestGenericTypedObject {
    final Mockery context = new Mockery();
    final Subject subject = (Subject)this.context.mock(Subject.class);
    final Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class);
    final LookupClosure lookupClosure = (LookupClosure)this.context.mock(LookupClosure.class);
    final Closure closure = (Closure)this.context.mock(Closure.class);
    final GenericTypedObject.MethodTargetFactory methodTargetFactory = (GenericTypedObject.MethodTargetFactory)this.context.mock(GenericTypedObject.MethodTargetFactory.class);
    final RuntimeContextInternal runtime = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);
    final RuntimeContextual runtimeContextual = (RuntimeContextual)this.context.mock(RuntimeContextual.class, "contextual1");
    final GenericTypedObject typedObject = new GenericTypedObject(this.subject, this.lookupClosure, this.methodTargetFactory);

    @Test
    public void methodDoesNotExist() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((LookupClosure)this.oneOf(TestGenericTypedObject.this.lookupClosure)).findMethodClosure(TestGenericTypedObject.this.typedObject, "unknown", 0);
                this.will(1.returnValue(null));
            }
        });
        MatcherAssert.assertThat((Object)this.typedObject.new_findSpecificMethod("unknown", 0, this.evaluator).isNone(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void methodExistsOnEvaluator() throws Exception {
        this.verifyMethodOnEvaluator("m");
    }

    @Test
    public void hasNoSutWhenTypedSystemUnderTestIsNull() throws Exception {
        GenericTypedObject genericTypedObject = new GenericTypedObject(new WithSut(null));
        MatcherAssert.assertThat((Object)genericTypedObject.hasTypedSystemUnderTest(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void hasSutWhenTypedSystemUnderTestIsNotNull() throws Exception {
        GenericTypedObject genericTypedObject = new GenericTypedObject(new WithSut("s"));
        MatcherAssert.assertThat((Object)genericTypedObject.hasTypedSystemUnderTest(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)genericTypedObject.getTypedSystemUnderTest().getSubject(), (Matcher)CoreMatchers.is((Object)"s"));
    }

    @Test
    public void doesNoInjectWhenTypedSystemUnderTestIsNull() throws Exception {
        GenericTypedObject genericTypedObject = new GenericTypedObject(new WithSut(null));
        genericTypedObject.injectRuntime(this.runtime);
    }

    @Test
    public void doesNoInjectWhenTypedSystemUnderTestIsNotRuntimeContextual() throws Exception {
        GenericTypedObject genericTypedObject = new GenericTypedObject(new WithSut("s"));
        genericTypedObject.injectRuntime(this.runtime);
    }

    @Test
    public void injectsWhenTypedSystemUnderTestIsRuntimeContextual() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextual)this.oneOf(TestGenericTypedObject.this.runtimeContextual)).setRuntimeContext(TestGenericTypedObject.this.runtime);
                ((RuntimeContextual)this.allowing(TestGenericTypedObject.this.runtimeContextual)).getSystemUnderTest();
                this.will(2.returnValue(null));
            }
        });
        GenericTypedObject genericTypedObject = new GenericTypedObject(new WithSut(this.runtimeContextual));
        genericTypedObject.injectRuntime(this.runtime);
    }

    @Test
    public void injectsTwiceWhenChainOfTypedSystemUnderTestIsRuntimeContextual() throws Exception {
        final RuntimeContextual runtimeContextual = (RuntimeContextual)this.context.mock(RuntimeContextual.class, "contextual2");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextual)this.oneOf(TestGenericTypedObject.this.runtimeContextual)).setRuntimeContext(TestGenericTypedObject.this.runtime);
                ((RuntimeContextual)this.allowing(TestGenericTypedObject.this.runtimeContextual)).getSystemUnderTest();
                this.will(3.returnValue((Object)runtimeContextual));
                ((RuntimeContextual)this.oneOf(runtimeContextual)).setRuntimeContext(TestGenericTypedObject.this.runtime);
                ((RuntimeContextual)this.allowing(runtimeContextual)).getSystemUnderTest();
                this.will(3.returnValue(null));
            }
        });
        GenericTypedObject genericTypedObject = new GenericTypedObject(new WithSut(this.runtimeContextual));
        genericTypedObject.injectRuntime(this.runtime);
    }

    @Test
    public void isNullWhenNullSubject() {
        MatcherAssert.assertThat((Object)new GenericTypedObject(null).isNull(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isNotNullWhenNotNullSubject() {
        MatcherAssert.assertThat((Object)new GenericTypedObject("s").isNull(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void classOfSubjectIsString() {
        MatcherAssert.assertThat(new GenericTypedObject("s").classType(), (Matcher)CoreMatchers.is(String.class));
    }

    @Test
    public void classOfSubjectIsPoint() {
        MatcherAssert.assertThat(new GenericTypedObject(new Point()).classType(), (Matcher)CoreMatchers.is(Point.class));
    }

    private void verifyMethodOnEvaluator(final String string) throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((GenericTypedObject.MethodTargetFactory)this.oneOf(TestGenericTypedObject.this.methodTargetFactory)).createCalledMethodTarget(TestGenericTypedObject.this.closure, TestGenericTypedObject.this.evaluator);
                ((LookupClosure)this.oneOf(TestGenericTypedObject.this.lookupClosure)).findMethodClosure(TestGenericTypedObject.this.typedObject, string, 0);
                this.will(4.returnValue((Object)TestGenericTypedObject.this.closure));
            }
        });
        MatcherAssert.assertThat((Object)this.typedObject.new_findSpecificMethod(string, 0, this.evaluator).isSome(), (Matcher)CoreMatchers.is((Object)true));
    }

    static class WithSut
    implements DomainAdapter {
        private final Object sut;

        public WithSut(Object object) {
            this.sut = object;
        }

        @Override
        public Object getSystemUnderTest() {
            return this.sut;
        }
    }

    static interface Sut {
        public void m();
    }

    static interface Subject
    extends Evaluator {
        public void m();
    }
}

