/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fitlibrary.exception.FitLibraryException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileIO {
    public static Iterator<File> filesIteratorWithSuffix(File diry, String suffix) {
        return FileIO.filesWithSuffix(diry, suffix).iterator();
    }

    public static List<File> filesWithSuffix(File diry, String suffix) {
        ArrayList<File> accumulatedFiles = new ArrayList<File>();
        FileIO.injectFile(diry, suffix, accumulatedFiles);
        return accumulatedFiles;
    }

    private static void injectFile(File diry, String suffix, List<File> accumulatedFiles) {
        File[] files = diry.listFiles();
        if (files == null) {
            throw new FitLibraryException("Not a directory: " + diry);
        }
        for (File f : files) {
            if (f.getName().endsWith(suffix)) {
                accumulatedFiles.add(f);
            }
            if (!f.isDirectory()) continue;
            FileIO.injectFile(f, suffix, accumulatedFiles);
        }
    }

    public static String read(File file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append("\n");
        }
        reader.close();
        return stringBuilder.toString();
    }
}

