/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.typed;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.Closure;
import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.closure.LookupClosure;
import fitlibrary.global.PlugBoard;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.FieldParser;
import fitlibrary.parser.lookup.GetterParser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.special.DoAction;
import fitlibrary.special.PositionedTarget;
import fitlibrary.special.PositionedTargetFactory;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.RuntimeContextual;
import fitlibrary.traverse.workflow.caller.ValidCall;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.option.None;
import fitlibrary.utility.option.Option;
import fitlibrary.utility.option.Some;
import fitlibraryGeneric.typed.GenericTyped;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class GenericTypedObject
implements TypedObject {
    private static Logger logger = FitLibraryLogger.getLogger(GenericTypedObject.class);
    public static final GenericTypedObject NULL = new GenericTypedObject(null);
    private final GenericTyped typed;
    private final Object subject;
    private final LookupClosure lookupClosure;
    private final MethodTargetFactory methodTargetFactory;

    public GenericTypedObject(Object subject, GenericTyped typed) {
        this(subject, typed, PlugBoard.lookupClosure, new MethodTargetFactory(){

            @Override
            public CalledMethodTarget createCalledMethodTarget(Closure closure, Evaluator evaluator) {
                return new CalledMethodTarget(closure, evaluator);
            }
        });
    }

    public GenericTypedObject(Object subject) {
        this(subject, GenericTypedObject.typeOf(subject));
    }

    public GenericTypedObject(Object subject, LookupClosure lookupClosure, MethodTargetFactory methodTargetFactory) {
        this(subject, GenericTypedObject.typeOf(subject), lookupClosure, methodTargetFactory);
    }

    protected GenericTypedObject(Object subject, GenericTyped typed, LookupClosure lookupClosure, MethodTargetFactory methodTargetFactory) {
        this.subject = subject;
        this.lookupClosure = lookupClosure;
        this.methodTargetFactory = methodTargetFactory;
        this.typed = typed;
    }

    private static GenericTyped typeOf(Object subject) {
        if (subject == null) {
            return new GenericTyped(Void.TYPE);
        }
        return new GenericTyped(subject.getClass());
    }

    @Override
    public Object getSubject() {
        return this.subject;
    }

    protected TypedObject asTypedObject(Object sut) {
        return new GenericTypedObject(sut);
    }

    @Override
    public Class<?> classType() {
        return this.subject.getClass();
    }

    protected Typed resultTyped(Method method) {
        Type genericReturnType = this.typed.bind(method.getGenericReturnType(), this.describe(method));
        return new GenericTyped(genericReturnType, true);
    }

    protected Typed resultTyped(Field field) {
        Type genericReturnType = this.typed.bind(field.getGenericType(), this.describe(field));
        return new GenericTyped(genericReturnType, true);
    }

    @Override
    public ResultParser resultParser(Evaluator evaluator, Method method) {
        Typed resultTyped = this.resultTyped(method);
        return new GetterParser(this.getTyped().on(evaluator, resultTyped, true), method);
    }

    @Override
    public ResultParser resultParser(Evaluator evaluator, Field field) {
        Typed resultTyped = this.resultTyped(field);
        return new FieldParser(this.getTyped().on(evaluator, resultTyped, true), field);
    }

    @Override
    public GetterParser resultParser(Evaluator evaluator, Method method, Class<?> actualResultType) {
        GenericTyped resultTyped = new GenericTyped(actualResultType, true);
        return new GetterParser(this.typed.on(evaluator, resultTyped, true), method);
    }

    @Override
    public ResultParser resultParser(Evaluator evaluator, Field field, Class<?> actualResultType) {
        GenericTyped resultTyped = new GenericTyped(actualResultType, true);
        return new FieldParser(this.typed.on(evaluator, resultTyped, true), field);
    }

    protected Typed parameterTyped(Method method, int parameterNo) {
        Type givenType = method.getGenericParameterTypes()[parameterNo];
        Type genericParameterType = this.typed.bind(givenType, this.describe(method));
        return new GenericTyped(genericParameterType, true);
    }

    @Override
    public TypedObject asReturnTypedObject(Object object, Method method) {
        return new GenericTypedObject(object, new GenericTyped(this.typed.bind(method.getGenericReturnType(), this.describe(method))));
    }

    @Override
    public TypedObject asReturnTypedObject(Object object, Field field) {
        return new GenericTypedObject(object, new GenericTyped(this.typed.bind(field.getGenericType(), this.describe(field))));
    }

    @Override
    public Parser[] parameterParsers(Evaluator evaluator, Method method) {
        Class<?>[] types = method.getParameterTypes();
        Parser[] parameterParsers = new Parser[types.length];
        for (int i = 0; i < types.length; ++i) {
            Typed parameterTyped = this.parameterTyped(method, i);
            parameterParsers[i] = this.getTyped().on(evaluator, parameterTyped, false);
        }
        return parameterParsers;
    }

    @Override
    public Evaluator traverse(Evaluator evaluator) {
        return this.getTyped().parser(evaluator).traverse(this);
    }

    @Override
    public void findMethodsFromPlainText(String textCall, List<ValidCall> results, RuntimeContextInternal runtime) {
        Method[] methods;
        List<String> words = Arrays.asList(textCall.split(" "));
        for (Method method : methods = this.subject.getClass().getMethods()) {
            int argCount = method.getParameterTypes().length;
            if (method.getDeclaringClass() == Object.class || PlugBoard.lookupClosure.fitLibrarySystemMethod(method, argCount, this.subject)) continue;
            ValidCall.parseAction(words, method.getName(), argCount, results, runtime);
        }
    }

    @Override
    public Closure findPublicMethodClosureForTypedObject(String name, Class<?>[] argTypes) {
        return PlugBoard.lookupClosure.findPublicMethodClosure(this, name, argTypes);
    }

    @Override
    public Option<ICalledMethodTarget> new_findSpecificMethod(String name, int argCount, Evaluator evaluator) {
        Option<Closure> methodClosureOption = this.new_findMethodClosure(name, argCount);
        if (methodClosureOption.isSome()) {
            return new Some<ICalledMethodTarget>(this.methodTargetFactory.createCalledMethodTarget(methodClosureOption.get(), evaluator));
        }
        return None.none();
    }

    private Option<Closure> new_findMethodClosure(String name, int argCount) {
        Closure methodClosure = this.lookupClosure.findMethodClosure(this, name, argCount);
        if (methodClosure == null) {
            return None.none();
        }
        return new Some<Closure>(methodClosure);
    }

    @Override
    public ICalledMethodTarget new_optionallyFindGetterOnTypedObject(String propertyName, Evaluator evaluator) {
        String getMethodName = evaluator.getRuntimeContext().extendedCamel("get " + propertyName);
        Option<ICalledMethodTarget> target = this.new_findSpecificMethod(getMethodName, 0, evaluator);
        if (target.isSome()) {
            return target.get();
        }
        String isMethodName = evaluator.getRuntimeContext().extendedCamel("is " + propertyName);
        target = this.new_findSpecificMethod(isMethodName, 0, evaluator);
        if (target.isSome()) {
            return target.get();
        }
        return null;
    }

    public String toString() {
        return "GenericTypedObject[" + this.subject + ":" + this.typed + "]";
    }

    @Override
    public Typed getTyped() {
        return this.typed;
    }

    @Override
    public boolean isNull() {
        return this.subject == null;
    }

    private String describe(Method method) {
        return "in " + method.toGenericString();
    }

    private String describe(Field field) {
        return "in " + field.getName();
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof GenericTypedObject)) {
            return false;
        }
        if (this.subject == null) {
            return ((GenericTypedObject)arg).subject == null;
        }
        return this.subject.equals(((GenericTypedObject)arg).subject);
    }

    public int hashCode() {
        if (this.subject == null) {
            return -123;
        }
        return this.subject.hashCode();
    }

    @Override
    public TypedObject getTypedSystemUnderTest() {
        if (this.subject instanceof Evaluator) {
            return ((Evaluator)this.subject).getTypedSystemUnderTest();
        }
        if (this.subject instanceof DomainAdapter) {
            return new GenericTypedObject(((DomainAdapter)this.subject).getSystemUnderTest());
        }
        throw new RuntimeException("No SUT");
    }

    @Override
    public boolean hasTypedSystemUnderTest() {
        return this.subject instanceof DomainAdapter && ((DomainAdapter)this.subject).getSystemUnderTest() != null;
    }

    @Override
    public void injectRuntime(RuntimeContextInternal runtime) {
        if (this.subject instanceof RuntimeContextual) {
            ((RuntimeContextual)this.subject).setRuntimeContext(runtime);
        }
        if (this.hasTypedSystemUnderTest()) {
            this.getTypedSystemUnderTest().injectRuntime(runtime);
        }
    }

    @Override
    public List<PositionedTarget> findActionSpecialMethods(String[] cells, PositionedTargetFactory factory, RuntimeContextInternal runtime) {
        Method[] methods;
        ArrayList<PositionedTarget> list = new ArrayList<PositionedTarget>();
        int cellCount = cells.length;
        for (Method method : methods = this.subject.getClass().getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            int paramCount = parameterTypes.length;
            if (paramCount <= 0 || cellCount <= paramCount) continue;
            if (this.isNullary(parameterTypes, paramCount)) {
                this.nullary(cells, factory, list, method, runtime);
                continue;
            }
            if (this.isPostfix(parameterTypes, paramCount)) {
                this.postFix(cells, factory, list, method, paramCount, runtime);
                continue;
            }
            if (!this.isPrefix(parameterTypes, paramCount)) continue;
            this.prefix(cells, factory, list, method, paramCount, runtime);
        }
        return list;
    }

    private boolean isPrefix(Class<?>[] parameterTypes, int paramCount) {
        return paramCount > 1 && parameterTypes[paramCount - 1] == DoAction.class;
    }

    private void prefix(String[] cells, PositionedTargetFactory factory, List<PositionedTarget> list, Method method, int paramCount, RuntimeContextInternal runtime) {
        String prefixName = this.prefixName(cells, paramCount, runtime);
        if (prefixName.equals(method.getName())) {
            list.add(factory.create(method, paramCount * 2 - 2, cells.length));
        }
    }

    private String prefixName(String[] cells, int paramCount, RuntimeContextInternal runtime) {
        String prefixName = cells[0];
        for (int i = 1; i < paramCount - 1; ++i) {
            prefixName = prefixName + " " + cells[i * 2];
        }
        return runtime.extendedCamel(prefixName);
    }

    private boolean isPostfix(Class<?>[] parameterTypes, int paramCount) {
        return paramCount > 1 && parameterTypes[0] == DoAction.class;
    }

    private void postFix(String[] cells, PositionedTargetFactory factory, List<PositionedTarget> list, Method method, int paramCount, RuntimeContextInternal runtime) {
        int cellCount = cells.length;
        int start = cellCount - 2 * paramCount + 2;
        String postfixName = this.postfixName(cells, paramCount, start, runtime);
        if (postfixName.equals(method.getName())) {
            list.add(factory.create(method, 0, start));
        }
    }

    private String postfixName(String[] cells, int paramCount, int start, RuntimeContextInternal runtime) {
        String postfixName = cells[start];
        for (int i = 1; i < paramCount - 1; ++i) {
            postfixName = postfixName + " " + cells[start + i * 2];
        }
        return runtime.extendedCamel(postfixName);
    }

    private boolean isNullary(Class<?>[] parameterTypes, int paramCount) {
        return paramCount == 1 && parameterTypes[0] == DoAction.class;
    }

    private void nullary(String[] cells, PositionedTargetFactory factory, List<PositionedTarget> list, Method method, RuntimeContextInternal runtime) {
        int cellCount = cells.length;
        if (runtime.extendedCamel(cells[0]).equals(method.getName())) {
            list.add(factory.create(method, 1, cellCount));
        } else if (cells[cellCount - 1].equals(method.getName())) {
            list.add(factory.create(method, 0, cellCount - 1));
        }
    }

    public static interface MethodTargetFactory {
        public ICalledMethodTarget createCalledMethodTarget(Closure var1, Evaluator var2);
    }
}

