/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.element;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.spider.AbstractSpiderFixture;
import fitlibrary.spider.element.SpiderElement;
import fitlibrary.spider.polling.PollForMatches;
import fitlibrary.spider.polling.PollForNoException;
import fitlibrary.spider.utility.WebElementSelector;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class ElementWithAttributes
extends SpiderElement {
    public ElementWithAttributes(AbstractSpiderFixture spiderFixture) {
        super(spiderFixture);
    }

    public boolean elementExists(final String locator) {
        try {
            this.ensureNoException(new PollForNoException<WebElement>(){

                @Override
                public WebElement act() {
                    return ElementWithAttributes.this.finder().findElement(locator);
                }
            });
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
        catch (Exception ex) {
            throw this.problem("Unknown xpath", locator);
        }
    }

    public boolean elementDoesNotExist(final String locator) {
        return this.ensureMatches(new PollForMatches(){

            @Override
            public boolean matches() {
                try {
                    ElementWithAttributes.this.finder().findElement(locator);
                    return false;
                }
                catch (Exception e) {
                    return true;
                }
            }
        });
    }

    public String elementValue(String locator) {
        return this.findElement(locator).getAttribute("value");
    }

    public String attributeOf(String attributeName, String locator) {
        String attribute = this.findElement(locator).getAttribute(attributeName);
        if (attribute == null) {
            throw new FitLibraryException("Missing attribute");
        }
        return attribute;
    }

    public boolean attributeOfExists(final String attributeName, final String locator) {
        return this.ensureMatches(new PollForMatches(){

            @Override
            public boolean matches() {
                String attribute = ElementWithAttributes.this.findElement(locator).getAttribute(attributeName);
                return attribute != null && !attribute.isEmpty();
            }
        });
    }

    public String withCssPropertyOf(String locator, String property) {
        return this.findElement(locator).getCssValue(property);
    }

    public int countOf(String locator) {
        return this.finder().findElements(locator).size();
    }

    public List<String> attributeOfChildrenOfTypeOf(String attribute, String childType, String locator) {
        ArrayList<String> result = new ArrayList<String>();
        for (WebElement e : this.childrenOf(locator, childType)) {
            if ("text".equals(attribute)) {
                result.add(e.getText());
                continue;
            }
            result.add(e.getAttribute(attribute));
        }
        return result;
    }

    private List<WebElement> childrenOf(String locator, String tag) {
        return this.findElement(locator).findElements(By.tagName((String)tag));
    }

    public WebElementSelector findElementFromWithTagWhere(String locator, String tag) {
        return new WebElementSelector(tag, this.findElement(locator).findElements(By.tagName((String)tag)), this.spiderFixture());
    }
}

