/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.specify;

import fitlibrary.runResults.TestResults;
import fitlibrary.server.WebServerForTesting;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.table.Row;
import fitlibrary.utility.StringUtility;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SpecifySpiderFixture
extends SpiderFixture {
    private String testFileName;
    private final int portNo;
    private final String driverName;
    private final WebServerForTesting webServer;

    public SpecifySpiderFixture() throws IOException {
        this(8096, "htmlUnit");
    }

    public SpecifySpiderFixture(int portNo, String driverName) throws IOException {
        this.portNo = portNo;
        this.driverName = driverName;
        this.webServer = new WebServerForTesting(portNo, "FitNesseRoot");
    }

    public boolean saveHtmlIn(String testingFileName) {
        this.testFileName = String.valueOf(this.driverName) + "/" + testingFileName;
        return true;
    }

    public void zeroReportCounts(Row row, TestResults testResults) throws Exception {
        testResults.clear();
    }

    public boolean withHtml(String html) throws Exception {
        String s = html.replaceAll("t-table", "table");
        s = StringUtility.replaceString((String)s, (String)"^@(", (String)"{");
        s = StringUtility.replaceString((String)s, (String)"^@)", (String)"}");
        s = StringUtility.replaceString((String)s, (String)"\\n", (String)"\n");
        s = StringUtility.replaceString((String)s, (String)"\\r", (String)"\r");
        s = StringUtility.replaceString((String)s, (String)"\\t", (String)"\t");
        this.writeFile(FITNESSE_DIFFERENCES.getLocalFile(this.testFileName).getFile(), s);
        this.selectInitialWindow();
        this.getUrl("http://localhost:" + this.portNo + "/files/" + this.testFileName);
        return true;
    }

    private void writeFile(File file, String html) throws IOException {
        this.createDirectory(file.getParentFile());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \n");
        fileWriter.write("<html>\n");
        fileWriter.write(html);
        fileWriter.write("\n</html>\n");
        fileWriter.close();
    }

    private void createDirectory(File diry) {
        if (!diry.exists()) {
            diry.mkdirs();
        }
    }

    public boolean makeFileFrom(String fileName, String html) throws IOException {
        String[] split = fileName.split("/");
        if (split.length > 1) {
            throw new RuntimeException("fix");
        }
        String fileName2 = split[split.length - 1];
        this.writeFile(FITNESSE_DIFFERENCES.getLocalFile(String.valueOf(this.driverName) + "/" + fileName2).getFile(), html);
        return true;
    }

    @Override
    public void shutDown() throws IOException {
        super.shutDown();
        this.webServer.stop();
    }

    @Override
    public void tearDown() throws Exception {
        this.shutDown();
        Thread.sleep(50L);
    }
}

