/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.http.Request;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualMockingPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.util.LinkedList;

public abstract class SecurePageOperation
implements SecureOperation {
    protected abstract String getSecurityMode();

    @Override
    public boolean shouldAuthenticate(FitNesseContext context, Request request) throws Exception {
        WikiPagePath path = PathParser.parse(request.getResource());
        PageCrawler crawler = context.root.getPageCrawler();
        crawler.setDeadEndStrategy(new VirtualMockingPageCrawler());
        WikiPage page = crawler.getPage(context.root, path);
        if (page == null) {
            return false;
        }
        LinkedList<WikiPage> ancestors = WikiPageUtil.getAncestorsStartingWith(page);
        for (WikiPage ancestor : ancestors) {
            if (!this.hasSecurityModeAttribute(ancestor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSecurityModeAttribute(WikiPage ancestor) throws Exception {
        PageData data = ancestor.getData();
        boolean hasSecurityMode = data.hasAttribute(this.getSecurityMode());
        return hasSecurityMode;
    }
}

