/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import util.Clock;

public class SaveRecorder {
    public static Random ticketNumGen = new Random();
    private static Map<String, Long> ticketRegistry = new HashMap<String, Long>();
    private static Map<String, Long> saveTime = new HashMap<String, Long>();

    public static long pageSaved(PageData data, long ticketNumber) throws Exception {
        long timeStamp = SaveRecorder.timeStamp();
        WikiPage page = data.getWikiPage();
        String name = page.getPageCrawler().getFullPath(page).toString();
        ticketRegistry.put(name, ticketNumber);
        saveTime.put(name, timeStamp);
        return timeStamp;
    }

    public static boolean changesShouldBeMerged(long thisEditTime, long ticket, PageData data) throws Exception {
        return new MergeDeterminer(thisEditTime, ticket, data).shouldMerge();
    }

    public static long timeStamp() {
        return Clock.currentTimeInMillis();
    }

    public static long newTicket() {
        return ticketNumGen.nextLong();
    }

    public static void clear() {
        ticketRegistry.clear();
        saveTime.clear();
    }

    private static class MergeDeterminer {
        private long thisEditTime;
        private long ticket;
        private WikiPage page;
        private String fullPageName;

        public MergeDeterminer(long thisEditTime, long ticket, PageData data) throws Exception {
            this.thisEditTime = thisEditTime;
            this.ticket = ticket;
            this.page = data.getWikiPage();
            this.fullPageName = this.page.getPageCrawler().getFullPath(this.page).toString();
        }

        public boolean shouldMerge() {
            return this.isSaveOutOfOrder() && !this.isSameEditSession();
        }

        private boolean isSameEditSession() {
            long pageTicketId;
            boolean sameEdit = false;
            if (ticketRegistry.containsKey(this.fullPageName) && (pageTicketId = ((Long)ticketRegistry.get(this.fullPageName)).longValue()) == this.ticket) {
                sameEdit = true;
            }
            return sameEdit;
        }

        private boolean isSaveOutOfOrder() {
            long lastSaveTime;
            boolean returnValue = false;
            if (saveTime.containsKey(this.fullPageName) && (lastSaveTime = ((Long)saveTime.get(this.fullPageName)).longValue()) > this.thisEditTime) {
                returnValue = true;
            }
            return returnValue;
        }
    }
}

