/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.ChunkedResponse;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.net.SocketException;

public abstract class ChunkingResponder
implements Responder {
    protected WikiPage root;
    public WikiPage page;
    protected WikiPagePath path;
    protected Request request;
    protected ChunkedResponse response;
    protected FitNesseContext context;
    private boolean dontChunk = false;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.context = context;
        this.request = request;
        this.root = context.root;
        String format = (String)request.getInput("format");
        this.response = new ChunkedResponse(format);
        if (this.dontChunk || context.doNotChunk || request.hasInput("nochunk")) {
            this.response.turnOffChunking();
        }
        this.getRequestedPage(request);
        if (this.page == null && this.shouldRespondWith404()) {
            return this.pageNotFoundResponse(context, request);
        }
        Thread respondingThread = new Thread((Runnable)new RespondingRunnable(), this.getClass() + ": Responding Thread");
        respondingThread.start();
        return this.response;
    }

    public void turnOffChunking() {
        this.dontChunk = true;
    }

    private void getRequestedPage(Request request) throws Exception {
        this.path = PathParser.parse(request.getResource());
        this.page = this.getPageCrawler().getPage(this.root, this.path);
    }

    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    private Response pageNotFoundResponse(FitNesseContext context, Request request) throws Exception {
        return new NotFoundResponder().makeResponse(context, request);
    }

    protected boolean shouldRespondWith404() {
        return true;
    }

    private void startSending() {
        try {
            this.doSending();
        }
        catch (SocketException e) {
        }
        catch (Exception e) {
            this.addExceptionAndCloseResponse(e);
        }
    }

    private void addExceptionAndCloseResponse(Exception e) {
        try {
            this.response.add(ErrorResponder.makeExceptionString(e));
            this.response.closeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getRenderedPath() {
        if (this.path != null) {
            return PathParser.render(this.path);
        }
        return this.request.getResource();
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    protected abstract void doSending() throws Exception;

    protected class RespondingRunnable
    implements Runnable {
        protected RespondingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ChunkingResponder.this.response.isReadyToSend()) {
                try {
                    ChunkedResponse chunkedResponse = ChunkingResponder.this.response;
                    synchronized (chunkedResponse) {
                        ChunkingResponder.this.response.notifyAll();
                        ChunkingResponder.this.response.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            ChunkingResponder.this.startSending();
        }
    }
}

